/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.mvc.redirect.send;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import ee.jakarta.tck.mvc.tests.mvc.redirect.send.SendRedirectController;
import ee.jakarta.tck.mvc.util.Archives;
import ee.jakarta.tck.mvc.util.MvcMatchers;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class SendRedirectTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(SendRedirectController.class).addView("Redirect target", "target.jsp").build();
    }

    @Before
    public void setUp() throws Exception {
        this.webClient = new WebClient();
        this.webClient.getOptions().setRedirectEnabled(false);
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
    }

    @Test
    @SpecAssertion(section="redirect", id="redirect-response")
    public void redirectViaResponse() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/send-redirect/response").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), MvcMatchers.isRedirectStatus());
        Assert.assertThat((Object)response.getResponseHeaderValue("Location"), (Matcher)CoreMatchers.endsWith((String)"/target"));
    }

    @Test
    @SpecAssertion(section="redirect", id="redirect-prefix")
    public void redirectViaRedirectPrefix() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/send-redirect/prefix").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), MvcMatchers.isRedirectStatus());
        Assert.assertThat((Object)response.getResponseHeaderValue("Location"), (Matcher)CoreMatchers.endsWith((String)"/target"));
    }

    @Test
    @SpecAssertion(section="redirect", id="redirect-relative")
    public void relativePathResponse() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/send-redirect/response").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), MvcMatchers.isRedirectStatus());
        Assert.assertThat((Object)response.getResponseHeaderValue("Location"), (Matcher)CoreMatchers.equalTo((Object)(this.baseUrl + "mvc/send-redirect/target")));
    }

    @Test
    @SpecAssertion(section="redirect", id="redirect-relative")
    public void relativePathRedirectPrefix() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/send-redirect/prefix").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), MvcMatchers.isRedirectStatus());
        Assert.assertThat((Object)response.getResponseHeaderValue("Location"), (Matcher)CoreMatchers.equalTo((Object)(this.baseUrl + "mvc/send-redirect/target")));
    }

    @Test
    @SpecAssertion(section="redirect", id="redirect-303-302")
    public void usesCorrectStatusCide() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/send-redirect/prefix").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)303), (Matcher)CoreMatchers.equalTo((Object)302)));
        Assert.assertThat((Object)response.getResponseHeaderValue("Location"), (Matcher)CoreMatchers.endsWith((String)"/target"));
    }
}

