/*
 * Copyright © 2017, 2019 Christian Kaltepoth
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */
package org.mvcspec.tck;

public class Sections {

    /*
     * Chapter: Models, Views and Controllers
     */
    public static final String MVC_CONTROLLERS = "controllers";
    public static final String MVC_CONTROLLER_INSTANCES = "controller_instances";
    public static final String MVC_RESPONSE = "response";
    public static final String MVC_REDIRECT = "redirect";
    public static final String MVC_MODELS = "models";
    public static final String MVC_VIEWS = "views";
    public static final String MVC_BUILDING_URIS = "mvc_uri";

    /*
     * Chapter: Data Binding
     */
    public static final String BINDING_ANNOTATION = "mvc_binding_annotation";
    public static final String BINDING_ERROR_HANDLING = "error_handling_bindingresult";
    public static final String BINDING_BOOLEAN_TYPE = "boolean_type";
    public static final String BINDING_NUMERIC_TYPE = "numeric_types";

    /*
     * Chapter: Security
     */
    public static final String SECURITY_CSRF = "cross-site-request-forgery";
    public static final String SECURITY_XSS = "cross-site-scripting";

    /*
     * Chapter: Events
     */
    public static final String EVENTS = "observers";

    /*
     * Chapter: Applications
     */
    public static final String APPLICATION_MVC_APPS = "mvc_applications";
    public static final String APPLICATION_MVC_CONTEXT = "mvc_context";
    public static final String APPLICATION_INHERITANCE = "annotation_inheritance";

    /*
     * Chapter: View Engines
     */
    public static final String VIEW_ENGINE_INTRO = "view_engines_introduction";
    public static final String VIEW_ENGINE_ALGORITHM = "selection_algorithm";

    /*
     * Chapter: Internationalization
     */
    public static final String I18N_INTRODUCTION = "i18n_introduction";
    public static final String I18N_RESOLVING_ALGORITHM = "i18n_resolving_algorithm";
    public static final String I18N_DEFAULT_RESOLVER = "i18n_default_resolver";

}
