/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Agent;
import com.sun.javatest.agent.AgentRemoteClassData;
import com.sun.javatest.agent.InstantiationClassLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.MissingResourceException;

class AgentClassLoader2
extends InstantiationClassLoader {
    private static volatile AgentClassLoader2 instance = null;
    private final HashMap<CodeSource, ProtectionDomain> pdcache = new HashMap(11);
    private CodeSource cs = null;
    private Agent.Task parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentClassLoader2(Agent.Task parent, ClassLoader cl) {
        super(cl);
        ProtectionDomain pd;
        this.parent = parent;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        if ((pd = this.getClass().getProtectionDomain()) != null) {
            this.cs = this.getClass().getProtectionDomain().getCodeSource();
            HashMap<CodeSource, ProtectionDomain> hashMap = this.pdcache;
            synchronized (hashMap) {
                this.pdcache.put(this.cs, pd);
            }
        }
    }

    private AgentClassLoader2(Agent.Task parent) {
        this(parent, parent.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static AgentClassLoader2 getInstance(Agent.Task parent) {
        if (instance == null) {
            Class<AgentClassLoader2> clazz = AgentClassLoader2.class;
            // MONITORENTER : com.sun.javatest.agent.AgentClassLoader2.class
            if (instance == null) {
                instance = new AgentClassLoader2(parent);
            }
            // MONITOREXIT : clazz
        }
        AgentClassLoader2.instance.parent = parent;
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain getProtectionDomain(CodeSource cs) {
        ProtectionDomain pd = null;
        HashMap<CodeSource, ProtectionDomain> hashMap = this.pdcache;
        synchronized (hashMap) {
            pd = this.pdcache.get(cs);
            if (pd == null) {
                Permissions perms = new Permissions();
                pd = new ProtectionDomain(cs, perms, this, null);
                this.pdcache.put(cs, pd);
            }
        }
        return pd;
    }

    public Class<?> loadClassLocal(String name) throws ClassNotFoundException {
        Class<?> target = null;
        System.out.println("FORCE REMOTE " + name);
        try {
            target = this.findClass(name);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            target = super.loadClass(name);
        }
        return target;
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        if (className != null) {
            String pkgName;
            int i = className.lastIndexOf(46);
            if (i > 0 && this.getPackage(pkgName = className.substring(0, i)) == null) {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            AgentRemoteClassData classData = this.parent.getClassData(className);
            ProtectionDomain pd = null;
            if (classData != null && classData.getCodeSource() != null) {
                try {
                    pd = this.getProtectionDomain(new CodeSource(new URL("file:" + classData.getCodeSource()), (CodeSigner[])null));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (pd == null) {
                pd = this.getProtectionDomain(this.cs);
            }
            return this.defineClass(className, classData.getByteData(), 0, classData.getByteData().length, pd);
        }
        throw new ClassNotFoundException();
    }

    @Override
    protected URL findResource(String name) {
        URL u = null;
        if (this.parent == null || name == null) {
            return null;
        }
        try {
            byte[] bytes = this.parent.getResourceData(name);
            u = bytes == null ? null : new URL("file", "", -1, name, new AgentURLStreamHandler(bytes));
        }
        catch (IOException | MissingResourceException e) {
            u = null;
        }
        return u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ClassLoader newClassLoaderInstance(ClassLoader parentCL) throws InstantiationClassLoader.InstantiationStateException {
        if (instance != null && instance.equals(this)) throw new InstantiationClassLoader.InstantiationStateException("Only one instance of the " + this.getClass().getName() + " class could exist");
        Class<AgentClassLoader2> clazz = AgentClassLoader2.class;
        synchronized (AgentClassLoader2.class) {
            if (instance != null && instance.equals(this)) throw new InstantiationClassLoader.InstantiationStateException("Only one instance of the " + this.getClass().getName() + " class could exist");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new AgentClassLoader2(this.parent, parentCL);
        }
    }

    private class AgentURLConnection
    extends URLConnection {
        private byte[] bytes;

        AgentURLConnection(URL url) {
            super(url);
        }

        AgentURLConnection(URL url, byte ... bytes) {
            super(url);
            this.bytes = bytes;
        }

        @Override
        public void connect() {
            this.connected = this.bytes != null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (AgentClassLoader2.this.parent == null) {
                throw new IOException("No parent agent to open connection with!");
            }
            if (this.bytes == null) {
                throw new IOException("No bytes available!!");
            }
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public String getContentEncoding() {
            return null;
        }

        @Override
        public int getContentLength() {
            if (this.bytes != null) {
                return this.bytes.length;
            }
            return -1;
        }

        @Override
        public String getContentType() {
            URL u;
            if (this.bytes == null) {
                return null;
            }
            String type = null;
            try {
                type = AgentURLConnection.guessContentTypeFromStream(this.getInputStream());
            }
            catch (Exception e) {
                type = null;
            }
            if (type == null && (u = this.getURL()) != null) {
                type = AgentURLConnection.guessContentTypeFromName(this.url.getPath());
            }
            return type;
        }

        @Override
        public long getDate() {
            return 0L;
        }

        @Override
        public long getExpiration() {
            return 0L;
        }

        @Override
        public long getLastModified() {
            return 0L;
        }
    }

    private class AgentURLStreamHandler
    extends URLStreamHandler {
        private byte[] bytes;

        AgentURLStreamHandler(byte ... bytes) {
            this.bytes = bytes;
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new AgentURLConnection(url, this.bytes);
        }
    }
}

