/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonreaderfactorytests;

import ee.jakarta.tck.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonReaderFactoryTest1() {
        boolean pass = true;
        JsonReader reader1 = null;
        JsonReader reader2 = null;
        JsonObject jsonObject = null;
        String jsonObjectText = "{\"foo\":\"bar\"}";
        try {
            LOGGER.info("Create JsonReaderFactory with Map<String, ?> with EMPTY config");
            JsonReaderFactory readerFactory = Json.createReaderFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("--------------------------------------------------");
            LOGGER.info("TEST CASE [JsonReaderFactory.createReader(Reader)]");
            LOGGER.info("--------------------------------------------------");
            LOGGER.info("Create 1st JsonReader using JsonReaderFactory");
            reader1 = readerFactory.createReader((Reader)new StringReader(jsonObjectText));
            if (reader1 == null) {
                LOGGER.warning("ReaderFactory failed to create reader1");
                pass = false;
            } else {
                jsonObject = reader1.readObject();
                reader1.close();
                if (!JSONP_Util.assertEquals((int)jsonObject.size(), (int)1) || !JSONP_Util.assertEquals((String)jsonObject.getString("foo"), (String)"bar")) {
                    pass = false;
                }
            }
            LOGGER.info("Create 2nd JsonReader using JsonReaderFactory");
            reader2 = readerFactory.createReader((Reader)new StringReader(jsonObjectText));
            if (reader2 == null) {
                LOGGER.warning("ReaderFactory failed to create reader2");
                pass = false;
            } else {
                jsonObject = reader2.readObject();
                reader2.close();
                if (!JSONP_Util.assertEquals((int)jsonObject.size(), (int)1) || !JSONP_Util.assertEquals((String)jsonObject.getString("foo"), (String)"bar")) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonReaderFactoryTest1 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonReaderFactoryTest1 Failed");
    }

    @Test
    public void jsonReaderFactoryTest2() {
        boolean pass = true;
        JsonReader reader1 = null;
        JsonReader reader2 = null;
        JsonObject jsonObject = null;
        String jsonObjectText = "{\"foo\":\"bar\"}";
        try {
            LOGGER.info("Create JsonReaderFactory with Map<String, ?> with EMPTY config");
            JsonReaderFactory readerFactory = Json.createReaderFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("----------------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonReaderFactory.createReader(InputStream, Charset)]");
            LOGGER.info("----------------------------------------------------------------");
            LOGGER.info("Create 1st JsonReader using JsonReaderFactory with UTF-8 encoding");
            InputStream is1 = JSONP_Util.getInputStreamFromString((String)jsonObjectText);
            reader1 = readerFactory.createReader(is1, JSONP_Util.UTF_8);
            if (reader1 == null) {
                LOGGER.warning("ReaderFactory failed to create reader1");
                pass = false;
            } else {
                jsonObject = reader1.readObject();
                reader1.close();
                if (!JSONP_Util.assertEquals((int)jsonObject.size(), (int)1) || !JSONP_Util.assertEquals((String)jsonObject.getString("foo"), (String)"bar")) {
                    pass = false;
                }
            }
            LOGGER.info("Create 2nd JsonReader using JsonReaderFactory with UTF-8 encoding");
            InputStream is2 = JSONP_Util.getInputStreamFromString((String)jsonObjectText);
            reader2 = readerFactory.createReader(is2, JSONP_Util.UTF_8);
            if (reader2 == null) {
                LOGGER.warning("ReaderFactory failed to create reader2");
                pass = false;
            } else {
                jsonObject = reader2.readObject();
                reader2.close();
                if (!JSONP_Util.assertEquals((int)jsonObject.size(), (int)1) || !JSONP_Util.assertEquals((String)jsonObject.getString("foo"), (String)"bar")) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonReaderFactoryTest2 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonReaderFactoryTest2 Failed");
    }

    @Test
    public void jsonReaderFactoryTest3() {
        boolean pass = true;
        JsonReader reader1 = null;
        JsonReader reader2 = null;
        JsonObject jsonObject = null;
        String jsonObjectText = "{\"foo\":\"bar\"}";
        try {
            LOGGER.info("Create JsonReaderFactory with Map<String, ?> with EMPTY config");
            JsonReaderFactory readerFactory = Json.createReaderFactory((Map)JSONP_Util.getEmptyConfig());
            LOGGER.info("Checking factory configuration properties");
            Map config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-------------------------------------------------------");
            LOGGER.info("TEST CASE [JsonReaderFactory.createReader(InputStream)]");
            LOGGER.info("-------------------------------------------------------");
            LOGGER.info("Create 1st JsonReader using JsonReaderFactory");
            InputStream is1 = JSONP_Util.getInputStreamFromString((String)jsonObjectText);
            reader1 = readerFactory.createReader(is1);
            if (reader1 == null) {
                LOGGER.warning("ReaderFactory failed to create reader1");
                pass = false;
            } else {
                jsonObject = reader1.readObject();
                reader1.close();
                if (!JSONP_Util.assertEquals((int)jsonObject.size(), (int)1) || !JSONP_Util.assertEquals((String)jsonObject.getString("foo"), (String)"bar")) {
                    pass = false;
                }
            }
            LOGGER.info("Create 2nd JsonReader using JsonReaderFactory");
            InputStream is2 = JSONP_Util.getInputStreamFromString((String)jsonObjectText);
            reader2 = readerFactory.createReader(is2);
            if (reader2 == null) {
                LOGGER.warning("ReaderFactory failed to create reader2");
                pass = false;
            } else {
                jsonObject = reader2.readObject();
                reader2.close();
                if (!JSONP_Util.assertEquals((int)jsonObject.size(), (int)1) || !JSONP_Util.assertEquals((String)jsonObject.getString("foo"), (String)"bar")) {
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonReaderFactoryTest3 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonReaderFactoryTest3 Failed");
    }

    @Test
    public void jsonReaderFactoryTest4() {
        boolean pass = true;
        try {
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Test scenario1: no supported provider property");
            LOGGER.info("----------------------------------------------");
            LOGGER.info("Create JsonReaderFactory with Map<String, ?> with EMPTY config");
            JsonReaderFactory readerFactory = Json.createReaderFactory((Map)JSONP_Util.getEmptyConfig());
            Map config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
            LOGGER.info("-----------------------------------------------");
            LOGGER.info("Test scenario2: non supported provider property");
            LOGGER.info("-----------------------------------------------");
            LOGGER.info("Create JsonReaderFactory with Map<String, ?> with FOO config");
            readerFactory = Json.createReaderFactory((Map)JSONP_Util.getFooConfig());
            config = readerFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck((Map)config, (int)0)) {
                pass = false;
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonReaderFactoryTest4 Failed: ", (Throwable)e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonReaderFactoryTest4 Failed");
    }
}

