/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.defaultmapping.polymorphictypes;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.annotation.JsonbSubtype;
import jakarta.json.bind.annotation.JsonbTypeInfo;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class MultipleTypeInfoTest {
    private static final Jsonb JSONB = JsonbBuilder.create();

    @Test
    public void testMultipleTypeInfoPropertySerialization() {
        String expected = "\\{\\s*\"@living\"\\s*:\\s*\"animal\"\\s*,\\s*\"@animal\"\\s*:\\s*\"dog\"\\s*,\\s*\"@dogRace\"\\s*:\\s*\"labrador\"\\s*,\\s*\"isLabrador\"\\s*:\\s*true\\s*\\}";
        Labrador labrador = new Labrador();
        MatcherAssert.assertThat((Object)JSONB.toJson((Object)labrador), (Matcher)Matchers.matchesPattern((String)expected));
    }

    @Test
    public void testMultipleTypeInfoPropertyDeserialization() {
        String json = "{\"@living\":\"animal\",\"@animal\":\"dog\",\"@dogRace\":\"labrador\",\"isLabrador\":true}";
        MatcherAssert.assertThat((Object)((Labrador)JSONB.fromJson(json, Labrador.class)), (Matcher)CoreMatchers.instanceOf(Labrador.class));
    }

    @Test
    public void testSerializeMultipleTypeInfoInSingleChain() {
        String expected = "\\{\\s*\"@machine\"\\s*:\\s*\"vehicle\"\\s*,\\s*\"@vehicle\"\\s*:\\s*\"car\"\\s*,\\s*\"machineProperty\"\\s*:\\s*\"machineProperty\"\\s*,\\s*\"vehicleProperty\"\\s*:\\s*\"vehicleProperty\"\\s*,\\s*\"carProperty\"\\s*:\\s*\"carProperty\"\\s*\\}";
        Car car = new Car();
        MatcherAssert.assertThat((Object)JSONB.toJson((Object)car), (Matcher)Matchers.matchesPattern((String)expected));
    }

    @Test
    public void testDeserializeMultipleTypeInfoInSingleChain() {
        String json = "{\"@machine\":\"vehicle\",\"@vehicle\":\"car\",\"machineProperty\":\"machineProperty\",\"vehicleProperty\":\"vehicleProperty\",\"carProperty\":\"carProperty\"}";
        Machine machine = (Machine)JSONB.fromJson(json, Machine.class);
        MatcherAssert.assertThat((Object)machine, (Matcher)CoreMatchers.instanceOf(Car.class));
    }

    public static class Car
    extends Vehicle {
        public String carProperty = "carProperty";
    }

    @JsonbTypeInfo(key="@vehicle", value={@JsonbSubtype(alias="car", type=Car.class)})
    public static class Vehicle
    extends Machine {
        public String vehicleProperty = "vehicleProperty";
    }

    @JsonbTypeInfo(key="@machine", value={@JsonbSubtype(alias="vehicle", type=Vehicle.class)})
    public static class Machine {
        public String machineProperty = "machineProperty";
    }

    public static class Labrador
    implements Dog {
        public boolean isLabrador = true;
    }

    @JsonbTypeInfo(key="@dogRace", value={@JsonbSubtype(alias="labrador", type=Labrador.class)})
    public static interface Dog
    extends Animal {
    }

    @JsonbTypeInfo(key="@animal", value={@JsonbSubtype(alias="dog", type=Dog.class)})
    public static interface Animal
    extends LivingThing {
    }

    @JsonbTypeInfo(key="@living", value={@JsonbSubtype(alias="animal", type=Animal.class)})
    public static interface LivingThing {
    }
}

