/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.ijson;

import ee.jakarta.tck.json.bind.customizedmapping.ijson.model.BinaryDataContainer;
import ee.jakarta.tck.json.bind.customizedmapping.ijson.model.CalendarContainer;
import ee.jakarta.tck.json.bind.customizedmapping.ijson.model.DateContainer;
import ee.jakarta.tck.json.bind.customizedmapping.ijson.model.DurationContainer;
import ee.jakarta.tck.json.bind.customizedmapping.ijson.model.GregorianCalendarContainer;
import ee.jakarta.tck.json.bind.customizedmapping.ijson.model.InstantContainer;
import ee.jakarta.tck.json.bind.customizedmapping.ijson.model.LocalDateContainer;
import ee.jakarta.tck.json.bind.customizedmapping.ijson.model.LocalDateTimeContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.JsonbException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IJsonSupportTest {
    private final Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withStrictIJSON(Boolean.valueOf(true)));

    @Test
    public void testStrictNonObjectOrArrayTopLevel() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonb.toJson((Object)"Test String"), (String)"Failed to restrict serialization of top-level JSON texts that are neither objects nor arrays when JsonbConfig.withStrictIJSON is used.");
    }

    @Test
    public void testStrictBinaryDataEncoding() {
        String jsonString = this.jsonb.toJson((Object)new BinaryDataContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal binary data using BASE_64_URL binary data encoding when JsonbConfig.withStrictIJSON is used.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"data\"\\s*:\\s*\"VGVzdCBTdHJpbmc=\"\\s*}"));
    }

    @Test
    public void testStrictDate() {
        final Calendar instance = Calendar.getInstance();
        instance.clear();
        instance.set(1970, 0, 1);
        instance.setTimeZone(TimeZone.getTimeZone("UTC"));
        String jsonString = this.jsonb.toJson((Object)new DateContainer(){
            {
                this.setInstance(instance.getTime());
            }
        });
        MatcherAssert.assertThat((String)"Failed to serialize java.util.Date in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+00:00\"\\s*}"));
    }

    @Test
    public void testStrictCalendar() {
        final Calendar calendarProperty = Calendar.getInstance();
        calendarProperty.clear();
        calendarProperty.set(1970, 0, 1);
        calendarProperty.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        String jsonString = this.jsonb.toJson((Object)new CalendarContainer(){
            {
                this.setInstance(calendarProperty);
            }
        });
        MatcherAssert.assertThat((String)"Failed to serialize java.util.Calendar in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+01:00\"\\s*}"));
    }

    @Test
    public void testStrictGregorianCalendar() {
        final GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1970, 0, 1, 0, 0, 0);
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        String jsonString = this.jsonb.toJson((Object)new GregorianCalendarContainer(){
            {
                this.setInstance(gregorianCalendar);
            }
        });
        MatcherAssert.assertThat((String)"Failed to serialize java.util.GregorianCalendar in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+01:00\"\\s*}"));
    }

    @Test
    public void testStrictLocalDate() {
        String jsonString = this.jsonb.toJson((Object)new LocalDateContainer(){
            {
                this.setInstance(LocalDate.of(1970, 1, 1));
            }
        });
        MatcherAssert.assertThat((String)"Failed to serialize java.time.LocalDate in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+00:00\"\\s*}"));
    }

    @Test
    public void testStrictLocalDateTime() {
        String jsonString = this.jsonb.toJson((Object)new LocalDateTimeContainer(){
            {
                this.setInstance(LocalDateTime.of(1970, 1, 1, 1, 1, 1));
            }
        });
        MatcherAssert.assertThat((String)"Failed to serialize java.time.LocalDate in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T01:01:01Z\\+00:00\"\\s*}"));
    }

    @Test
    public void testStrictInstant() {
        String jsonString = this.jsonb.toJson((Object)new InstantContainer(){
            {
                this.setInstance(Instant.ofEpochMilli(0L));
            }
        });
        MatcherAssert.assertThat((String)"Failed to serialize java.time.Instant in the same format as java.time.ZonedDateTime when JsonbConfig.withStrictIJSON is used.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"1970-01-01T00:00:00Z\\+00:00\"\\s*}"));
    }

    @Test
    public void testStrictDuration() {
        String jsonString = this.jsonb.toJson((Object)new DurationContainer(){
            {
                this.setInstance(Duration.ofDays(1L).plus(Duration.ofHours(1L)).plus(Duration.ofSeconds(1L)));
            }
        });
        MatcherAssert.assertThat((String)"Failed to serialize java.time.Duration in the same format as in Appendix A of RFC 3339.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"instance\"\\s*:\\s*\"PT25H1S\"\\s*}"));
    }
}

