/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Merge;
import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.classpath.ClasspathImpl;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.ClassSet;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Exclude;
import com.sun.tdk.signaturetest.core.ExcludeException;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.core.PackageGroup;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.core.context.TestOptions;
import com.sun.tdk.signaturetest.errors.BCProcessor;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.errors.HumanErrorFormatter;
import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.errors.SortedErrorFormatter;
import com.sun.tdk.signaturetest.loaders.LoadingHints;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.AnnotationItemEx;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperClass;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import com.sun.tdk.signaturetest.updater.Updater;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.Level;
import com.sun.tdk.signaturetest.util.OptionInfo;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class SignatureTest
extends SigTest {
    public static final String CHECKVALUE_OPTION = "-CheckValue";
    public static final String NOCHECKVALUE_OPTION = "-NoCheckValue";
    public static final String MODE_OPTION = "-Mode";
    public static final String ENABLESUPERSET_OPTION = "-EnableSuperSet";
    public static final String FILES_OPTION = "-Files";
    public static final String NOMERGE_OPTION = "-NoMerge";
    public static final String WRITE_OPTION = "-Write";
    public static final String UPDATE_FILE_OPTION = "-Update";
    public static final String SECURE_PACKAGES_OPTION = "-Secure";
    private String logName = null;
    private String outFormat = null;
    private boolean extensibleInterfaces = false;
    private Set<String> orderImportant;
    private static final I18NResourceBundle i18nSt = I18NResourceBundle.getBundleForClass(SignatureTest.class);
    private boolean logFile = false;
    private Set<String> trackedClassNames;
    private Boolean isValueTracked = null;
    private boolean isOneWayConstantChecking = false;
    private String writeFileName = null;
    private String updateFileName = null;
    private String mode = null;
    public static final String BINARY_MODE = "bin";
    private static final String SOURCE_MODE = "src";
    private static final String EXT_MODE = "src-ext";
    private static final String FORMAT_PLAIN = "plain";
    private static final String FORMAT_HUMAN = "human";
    private static final String FORMAT_BACKWARD = "backward";
    private static final String ORDANN_OPTION = "-OrdAnn";
    private boolean isSupersettingEnabled = false;
    private boolean isThrowsRemoved = false;
    private ClassHierarchy signatureClassesHierarchy;
    private final Erasurator erasurator = new Erasurator();
    protected Exclude exclude;
    private int readMode = 2;
    protected final PackageGroup secure = new PackageGroup(true);

    public static void main(String[] args) {
        SignatureTest t = SignatureTest.getInstance();
        t.run(args, new PrintWriter(System.err, true), null);
        t.exit();
    }

    protected static SignatureTest getInstance() {
        return new SignatureTest();
    }

    public void run(String[] args, PrintWriter log, PrintWriter ref) {
        AppContext.getContext().clean();
        this.setLog(log);
        this.mode = null;
        try {
            ClassLoader cl = SignatureTest.class.getClassLoader();
            this.exclude = (Exclude)cl.loadClass(System.getProperty("exclude.plugin")).newInstance();
        }
        catch (Exception e) {
            this.exclude = new DefaultExcludeList();
        }
        if (this.parseParameters(args)) {
            this.check();
            if (this.logFile) {
                this.getLog().println(this.toString());
            }
        }
        if (this.getClasspath() != null) {
            this.getClasspath().close();
        }
        if (this.logFile) {
            this.getLog().close();
            System.out.println(i18nSt.getString("SignatureTest.mesg.see_log", this.logName));
        }
    }

    private void correctConstants(ClassDescription currentClass) {
        for (FieldDescr fd : currentClass.getDeclaredFields()) {
            if (fd.isStatic()) continue;
            fd.setConstantValue(null);
        }
    }

    private boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        TestOptions to = AppContext.getContext().getBean(TestOptions.class);
        args = this.exclude.parseParameters(args);
        String optionsDecoder = "decodeOptions";
        parser.addOption(FILES_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ApiVersion", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Out", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ClassCacheSize", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ExtensibleInterfaces", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-XnoTiger", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Xverbose", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(CHECKVALUE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(NOCHECKVALUE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(ENABLESUPERSET_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(UPDATE_FILE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(MODE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Verbose", OptionInfo.optionVariableParams(0, 1), "decodeOptions");
        parser.addOption("-Plugin", OptionInfo.option(1), "decodeOptions");
        parser.addOption(NOMERGE_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(WRITE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption("-ErrorAll", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption(ORDANN_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOption(SECURE_PACKAGES_OPTION, OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), "decodeOptions");
        parser.addOptions(bo.getOptions(), "decodeOptions");
        parser.addOptions(to.getOptions(), "decodeOptions");
        try {
            parser.processArgs(args);
        }
        catch (CommandLineParserException e) {
            this.getLog().println(e.getMessage());
            return this.failed(e.getMessage());
        }
        if (!this.processHelpOptions()) {
            return false;
        }
        this.packages.addPackages(bo.getValues(Option.PACKAGE));
        this.purePackages.addPackages(bo.getValues(Option.PURE_PACKAGE));
        this.excludedPackages.addPackages(bo.getValues(Option.EXCLUDE));
        this.apiIncl.addPackages(bo.getValues(Option.API_INCLUDE));
        this.apiExcl.addPackages(bo.getValues(Option.API_EXCLUDE));
        if (this.packages.isEmpty() && this.purePackages.isEmpty() && this.apiIncl.isEmpty()) {
            this.packages.addPackage("");
        }
        this.initDefaultAnnotations();
        if (bo.getValue(Option.FILE_NAME) != null) {
            this.readMode = 1;
        }
        if (bo.isSet(Option.STATIC) && !parser.isOptionSpecified(Option.CLASSPATH.getKey())) {
            return this.error(i18nSt.getString("SignatureTest.error.static.missing_option", Option.CLASSPATH.getKey()));
        }
        if (bo.getValue(Option.FILE_NAME) == null && !parser.isOptionSpecified(FILES_OPTION)) {
            Object[] invargs = new String[]{Option.FILE_NAME.getKey(), FILES_OPTION};
            return this.error(i18nSt.getString("SignatureTest.error.options.filename_options", invargs));
        }
        if (bo.getValue(Option.FILE_NAME) != null && parser.isOptionSpecified(FILES_OPTION)) {
            Object[] invargs = new String[]{Option.FILE_NAME.getKey(), FILES_OPTION};
            return this.error(i18nSt.getString("Setup.error.options.cant_be_used_together", invargs));
        }
        if (to.isSet(Option.BACKWARD) && to.isSet(Option.FORMATHUMAN)) {
            Object[] invargs = new String[]{Option.BACKWARD.getKey(), Option.FORMATHUMAN.getKey()};
            return this.error(i18nSt.getString("Setup.error.options.cant_be_used_together", invargs));
        }
        this.logFile = false;
        if (this.logName != null) {
            try {
                this.setLog(new PrintWriter((Writer)new FileWriter(this.logName), true));
                this.logFile = true;
            }
            catch (IOException x) {
                if (bo.isSet(Option.DEBUG)) {
                    SwissKnife.reportThrowable(x);
                }
                return this.error(i18nSt.getString("SignatureTest.error.out.invfile", "-Out"));
            }
        }
        try {
            if (!bo.isSet(Option.STATIC) && this.isPlatformEnumerationSupported()) {
                try {
                    Class<?> epci = Class.forName("com.sun.tdk.signaturetest.classpath.EnumPlatformClasspathImpl");
                    Classpath cp = (Classpath)epci.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.setClasspath(cp);
                }
                catch (Exception e) {
                    this.setClasspath(new ClasspathImpl(bo.getValue(Option.CLASSPATH)));
                }
            } else {
                this.setClasspath(new ClasspathImpl(bo.getValue(Option.CLASSPATH)));
            }
        }
        catch (SecurityException e) {
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            this.getLog().println(i18nSt.getString("SignatureTest.error.sec.newclasses"));
        }
        if (bo.isSet(Option.STATIC) && this.getClasspath().isEmpty()) {
            return this.error(i18nSt.getString("SignatureTest.error.classpath.unspec"));
        }
        return this.passed();
    }

    private boolean isPlatformEnumerationSupported() {
        try {
            Class.forName("java.lang.module.ModuleReader").getMethod("list", new Class[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        TestOptions to = AppContext.getContext().getBean(TestOptions.class);
        if (to.readOptions(optionName, args)) {
            return;
        }
        if (optionName.equalsIgnoreCase(FILES_OPTION)) {
            this.sigFileNameList = args[0];
        } else if (optionName.equalsIgnoreCase("-ExtensibleInterfaces")) {
            this.extensibleInterfaces = true;
        } else if (optionName.equalsIgnoreCase(CHECKVALUE_OPTION)) {
            this.isValueTracked = Boolean.TRUE;
        } else if (optionName.equalsIgnoreCase(NOCHECKVALUE_OPTION)) {
            this.isValueTracked = Boolean.FALSE;
        } else if (optionName.equalsIgnoreCase(WRITE_OPTION)) {
            this.writeFileName = args[0];
        } else if (optionName.equalsIgnoreCase(UPDATE_FILE_OPTION)) {
            this.updateFileName = args[0];
        } else if (optionName.equalsIgnoreCase(MODE_OPTION)) {
            if (!(SOURCE_MODE.equalsIgnoreCase(args[0]) || BINARY_MODE.equalsIgnoreCase(args[0]) || EXT_MODE.equalsIgnoreCase(args[0]))) {
                throw new CommandLineParserException(i18nSt.getString("SignatureTest.error.arg.invalid", MODE_OPTION));
            }
            this.mode = args[0];
        } else if (optionName.equalsIgnoreCase("-Out")) {
            this.logName = args[0];
        } else if (optionName.equalsIgnoreCase(ENABLESUPERSET_OPTION)) {
            this.isSupersettingEnabled = true;
        } else if (optionName.equalsIgnoreCase(NOMERGE_OPTION)) {
            this.readMode = 1;
        } else if (optionName.equalsIgnoreCase(ORDANN_OPTION)) {
            if (this.orderImportant == null) {
                this.orderImportant = new TreeSet<String>();
            }
            this.orderImportant.addAll(Arrays.asList(CommandLineParser.parseListOption(args)));
        } else if (optionName.equalsIgnoreCase(SECURE_PACKAGES_OPTION)) {
            this.secure.addPackages(CommandLineParser.parseListOption(args));
        } else {
            super.decodeCommonOptions(optionName, args);
        }
    }

    @Override
    protected void usage() {
        String nl = System.getProperty("line.separator");
        String sb = this.getComponentName() + " - " + i18nSt.getString("SignatureTest.usage.version", "4.1") + nl + i18nSt.getString("SignatureTest.usage.start") + nl + i18nSt.getString("Sigtest.usage.delimiter") + nl + i18nSt.getString("SignatureTest.usage.static", Option.STATIC) + nl + i18nSt.getString("SignatureTest.usage.mode", MODE_OPTION) + nl + i18nSt.getString("SignatureTest.usage.backward", new Object[]{Option.BACKWARD.getKey(), Option.BACKWARD.getAlias()}) + nl + i18nSt.getString("SignatureTest.usage.classpath", Option.CLASSPATH.getKey()) + nl + i18nSt.getString("SignatureTest.usage.filename", Option.FILE_NAME) + nl + i18nSt.getString("SignatureTest.usage.or") + nl + i18nSt.getString("SignatureTest.usage.files", new Object[]{FILES_OPTION, File.pathSeparator}) + nl + i18nSt.getString("SignatureTest.usage.package", Option.PACKAGE.getKey()) + nl + i18nSt.getString("SignatureTest.usage.human", new Object[]{Option.FORMATHUMAN.getKey(), Option.FORMATHUMAN.getAlias()}) + nl + i18nSt.getString("SignatureTest.usage.out", "-Out") + nl + i18nSt.getString("Sigtest.usage.delimiter") + nl + i18nSt.getString("SignatureTest.usage.testurl", Option.TEST_URL) + nl + i18nSt.getString("SignatureTest.usage.packagewithoutsubpackages", Option.PURE_PACKAGE.getKey()) + nl + i18nSt.getString("SignatureTest.usage.exclude", Option.EXCLUDE.getKey()) + nl + i18nSt.getString("SignatureTest.usage.nomerge", NOMERGE_OPTION) + nl + i18nSt.getString("SignatureTest.usage.update", UPDATE_FILE_OPTION) + nl + i18nSt.getString("SignatureTest.usage.apiversion", "-ApiVersion") + nl + i18nSt.getString("SignatureTest.usage.checkvalue", CHECKVALUE_OPTION) + nl + i18nSt.getString("SignatureTest.usage.formatplain", Option.FORMATPLAIN) + nl + i18nSt.getString("SignatureTest.usage.extinterfaces", "-ExtensibleInterfaces") + nl + i18nSt.getString("Sigtest.usage.delimiter") + nl + i18nSt.getString("SignatureTest.usage.classcachesize", new Object[]{"-ClassCacheSize", 1024}) + nl + i18nSt.getString("SignatureTest.usage.verbose", new Object[]{"-Verbose", "nowarn"}) + nl + i18nSt.getString("SignatureTest.usage.debug", Option.DEBUG.getKey()) + nl + i18nSt.getString("SignatureTest.usage.error_all", "-ErrorAll") + nl + i18nSt.getString("Sigtest.usage.delimiter") + nl + i18nSt.getString("SignatureTest.helpusage.version", Option.VERSION.getKey()) + nl + i18nSt.getString("SignatureTest.usage.help", Option.HELP.getKey()) + nl + i18nSt.getString("Sigtest.usage.delimiter") + nl + i18nSt.getString("SignatureTest.usage.end");
        System.err.println(sb);
    }

    private void initDefaultAnnotations() {
        if (this.orderImportant == null) {
            this.orderImportant = new TreeSet<String>();
            this.orderImportant.add("javax.xml.bind.annotation.XmlType");
            this.orderImportant.add("java.beans.ConstructorProperties");
        }
    }

    @Override
    protected String getComponentName() {
        return "Test";
    }

    @Override
    public boolean useErasurator() {
        return !isTigerFeaturesTracked || BINARY_MODE.equals(this.mode);
    }

    private boolean check() {
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        TestOptions to = AppContext.getContext().getBean(TestOptions.class);
        String sigFileName = bo.getValue(Option.FILE_NAME);
        String testURL = bo.getValue(Option.TEST_URL);
        if (testURL == null) {
            testURL = "";
        }
        if (to.isSet(Option.FORMATPLAIN)) {
            this.outFormat = FORMAT_PLAIN;
        } else if (to.isSet(Option.FORMATHUMAN)) {
            this.outFormat = FORMAT_HUMAN;
        } else if (to.isSet(Option.BACKWARD)) {
            this.outFormat = FORMAT_BACKWARD;
        }
        if (this.pluginClass != null) {
            this.pluginClass.init(this);
        }
        PrintWriter log = this.getLog();
        if (this.readMode == 2 && this.sigFileNameList != null && this.sigFileNameList.contains(File.pathSeparator)) {
            try {
                if (this.writeFileName == null) {
                    File tmpF = File.createTempFile("sigtest", "sig");
                    this.writeFileName = tmpF.getAbsolutePath();
                    tmpF.deleteOnExit();
                }
                Merge m = Merge.getInstance();
                String[] args = new String[]{FILES_OPTION, this.sigFileNameList, WRITE_OPTION, this.writeFileName};
                if (BINARY_MODE.equals(this.mode)) {
                    args = new String[]{FILES_OPTION, this.sigFileNameList, WRITE_OPTION, this.writeFileName, "-Binary"};
                }
                m.run(args, log, null);
                if (!m.isPassed()) {
                    this.error(m.getReason());
                    return false;
                }
                this.readMode = 1;
                sigFileName = this.writeFileName;
                this.sigFileNameList = null;
                testURL = "";
            }
            catch (IOException ex) {
                SwissKnife.reportThrowable(ex, log);
                return this.error(i18nSt.getString("SignatureTest.error.tmpsigfile"));
            }
        } else {
            this.readMode = 1;
        }
        if (this.updateFileName != null) {
            try {
                Updater up = new Updater();
                File res = File.createTempFile("sigtest", "sig");
                String resFileName = res.getAbsolutePath();
                res.deleteOnExit();
                up.perform(this.updateFileName, sigFileName, resFileName, log);
                sigFileName = resFileName;
            }
            catch (IOException e) {
                SwissKnife.reportThrowable(e);
            }
        }
        MultipleFileReader in = new MultipleFileReader(log, this.readMode, this.getFileManager());
        String linesep = System.getProperty("line.separator");
        boolean result = this.sigFileNameList != null ? in.readSignatureFiles(testURL, this.sigFileNameList) : in.readSignatureFile(testURL, sigFileName);
        if (!result) {
            in.close();
            String msg = i18nSt.getString("SignatureTest.error.sigfile.invalid", this.sigFileNameList == null ? sigFileName : this.sigFileNameList);
            log.println(msg);
            return this.error(msg);
        }
        if (!this.prepareCheck(in, log)) {
            return false;
        }
        boolean buildMembers = in.isFeatureSupported(FeaturesHolder.BuildMembers);
        MemberCollectionBuilder sigfileMCBuilder = null;
        if (buildMembers) {
            sigfileMCBuilder = new MemberCollectionBuilder(this, "source:sigfile");
        }
        Erasurator localErasurator = new Erasurator();
        String msg = null;
        try {
            ClassDescription currentClass;
            ClassSet closedSet = new ClassSet(this.signatureClassesHierarchy, true);
            in.rewind();
            while ((currentClass = in.nextClass()) != null) {
                closedSet.addClass(currentClass.getQualifiedName());
            }
            Set<String> missingClasses = closedSet.getMissingClasses();
            if (!missingClasses.isEmpty() && !this.allowMissingSuperclasses()) {
                log.print(i18nSt.getString("SignatureTest.error.required_classes_missing"));
                int count = 0;
                for (String missingClass : missingClasses) {
                    if (count != 0) {
                        log.print(", ");
                    }
                    log.print(missingClass);
                    ++count;
                }
                log.println();
                return this.error(i18nSt.getString("SignatureTest.error.non_transitively_closed_set"));
            }
            in.rewind();
            boolean supportNSC = in.isFeatureSupported(FeaturesHolder.NonStaticConstants);
            while ((currentClass = in.nextClass()) != null) {
                block55: {
                    Transformer t;
                    block54: {
                        if (Xverbose) {
                            this.getLog().println(i18nSt.getString("SignatureTest.mesg.verbose.check", currentClass.getQualifiedName()));
                            this.getLog().flush();
                        }
                        if (to.isSet(Option.CHECK_EXCESS_CLASSES_ONLY)) {
                            this.trackedClassNames.add(currentClass.getQualifiedName());
                            continue;
                        }
                        if (buildMembers && sigfileMCBuilder != null) {
                            try {
                                if (this.isAPICheckMode()) {
                                    sigfileMCBuilder.setBuildMode(MemberCollectionBuilder.BuildMode.SIGFILE);
                                }
                                sigfileMCBuilder.createMembers(currentClass, this.addInherited(), false, true);
                            }
                            catch (ClassNotFoundException e) {
                                if (!bo.isSet(Option.DEBUG)) break block54;
                                SwissKnife.reportThrowable(e);
                            }
                        }
                    }
                    if (this.useErasurator()) {
                        currentClass = localErasurator.erasure(currentClass);
                    }
                    if ((t = PluginAPI.BEFORE_TEST.getTransformer()) != null) {
                        try {
                            t.transform(currentClass);
                        }
                        catch (ClassNotFoundException e) {
                            if (!bo.isSet(Option.DEBUG)) break block55;
                            SwissKnife.reportThrowable(e);
                        }
                    }
                }
                if (currentClass.isModuleOrPackaheInfo() && isTigerFeaturesTracked) {
                    this.verifyMduleOrPackageInfo(currentClass);
                } else {
                    this.verifyClass(currentClass, supportNSC);
                }
                if (this.isAPICheckMode()) continue;
                currentClass.setMembers(null);
            }
        }
        catch (OutOfMemoryError e) {
            msg = i18nSt.getString("SignatureTest.error.sigfile.oome");
        }
        catch (StackOverflowError e) {
            msg = i18nSt.getString("SignatureTest.error.sigfile.soe");
        }
        catch (VirtualMachineError e) {
            msg = i18nSt.getString("SignatureTest.error.sigfile.vme", e.getMessage());
        }
        catch (IOException e) {
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            msg = i18nSt.getString("SignatureTest.error.sigfile.prob") + linesep + e;
        }
        catch (SecurityException e) {
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            msg = i18nSt.getString("SignatureTest.error.sigfile.sec") + linesep + e;
        }
        catch (AssertionError ass) {
            SwissKnife.reportThrowable((Throwable)((Object)ass));
        }
        catch (Error e) {
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            msg = i18nSt.getString("SignatureTest.error.unknownerror") + e;
        }
        if (msg != null) {
            in.close();
            log.println(msg);
            return this.error(msg);
        }
        if (!this.isSupersettingEnabled) {
            this.checkAddedClasses();
        }
        if (isTigerFeaturesTracked) {
            this.checkAddedPackages();
        }
        int auxErrorCount = 0;
        this.getErrorManager().printErrors();
        if (this.reportWarningAsError) {
            auxErrorCount = this.errorMessages.size();
            this.printErrors();
        }
        log.println("");
        String repmsg = this.exclude.report();
        if (this.isVerbose) {
            System.out.println(repmsg);
        }
        int numErrors = this.getErrorManager().getNumErrors() + auxErrorCount;
        in.close();
        if (numErrors == 0) {
            return this.passed();
        }
        return this.failed(i18nSt.getString("MTest.msg.failed", Integer.toString(numErrors)));
    }

    protected boolean allowMissingSuperclasses() {
        return false;
    }

    protected boolean normalizeReq() {
        return true;
    }

    protected boolean isAPICheckMode() {
        return false;
    }

    protected void setupLoaders(ClassDescriptionLoader loader, ClassDescriptionLoader second) {
    }

    private void checkAddedClasses() {
        if (this.getClasspath() == null) {
            return;
        }
        try {
            while (this.getClasspath().hasNext()) {
                String name = ExoticCharTools.encodeExotic(this.getClasspath().nextClassName());
                this.checkAddedClass(name);
            }
        }
        catch (SecurityException ex) {
            BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(ex);
            }
            this.getLog().println(i18nSt.getString("SignatureTest.mesg.classpath.sec"));
            this.getLog().println(ex);
        }
    }

    private void checkAddedClass(String name) {
        block10: {
            if (!this.trackedClassNames.contains(name) && this.isPackageMember(name)) {
                BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
                try {
                    ClassDescription c = this.testableHierarchy.load(name);
                    if (c.isModuleOrPackaheInfo()) {
                        if (isTigerFeaturesTracked) {
                            this.checkAnnotations(null, c, null, null, null, this.testableHierarchy);
                        }
                    } else if (this.testableHierarchy.isAccessible(c)) {
                        this.exclude.check(c, c);
                        Filter f = PluginAPI.BEFORE_TEST.getFilter();
                        if (f != null && !f.accept(c)) {
                            return;
                        }
                        this.checkSupers(c);
                        this.getErrorManager().addError(MessageType.getAddedMessageType(c.getMemberType()), c.getQualifiedName(), c.getMemberType(), null, c);
                    }
                }
                catch (ClassNotFoundException | LinkageError ex) {
                    if (bo.isSet(Option.DEBUG)) {
                        SwissKnife.reportThrowable(ex);
                    }
                }
                catch (ExcludeException e) {
                    if (!this.isVerbose) break block10;
                    this.getLog().println(i18nSt.getString("SignatureTest.mesg.verbose.checkAddedClass", new Object[]{name, e.getMessage()}));
                    this.getLog().flush();
                }
            }
        }
    }

    private void checkAddedPackages() {
        ArrayList<String> wrk = new ArrayList<String>();
        for (String trackedClassName : this.trackedClassNames) {
            String pkg = ClassDescription.getPackageName(trackedClassName);
            if (wrk.contains(pkg)) continue;
            wrk.add(pkg);
        }
        Collections.sort(wrk);
        for (String o : wrk) {
            String fqn = ClassDescription.getPackageInfo(o);
            if (this.trackedClassNames.contains(fqn)) continue;
            try {
                ClassDescription c = this.testableHierarchy.load(fqn);
                this.checkAnnotations(null, c, null, null, null, this.testableHierarchy);
            }
            catch (Throwable throwable) {}
        }
    }

    private void transformPair(ClassDescription parentReq, MemberDescription required, ClassDescription parentFou, MemberDescription found) {
        if (required.isConstructor() && found.isConstructor() && parentReq.isAbstract() && parentFou.isAbstract() && (required.isProtected() && found.isPublic() || required.isPublic() && found.isProtected())) {
            required.setModifiers(required.getModifiers() & ~Modifier.PUBLIC.getValue());
            required.setModifiers(required.getModifiers() | Modifier.PROTECTED.getValue());
            found.setModifiers(found.getModifiers() & ~Modifier.PUBLIC.getValue());
            found.setModifiers(found.getModifiers() | Modifier.PROTECTED.getValue());
        }
        if (found.hasModifier(Modifier.FINAL) && !required.hasModifier(Modifier.FINAL) && found.isMethod() && required.isMethod() && !found.getDeclaringClassName().equals(required.getDeclaringClassName())) {
            found.removeModifier(Modifier.FINAL);
        }
    }

    protected boolean verifyClass(ClassDescription required, boolean supportNSC) {
        block22: {
            String name = required.getQualifiedName();
            BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
            if (!this.isPackageMember(name)) {
                return this.passed();
            }
            try {
                this.exclude.check(required, required);
                ClassDescription found = this.testableHierarchy.load(name);
                this.checkSupers(found);
                if (this.testableHierarchy.isAccessible(found)) {
                    if (this.isAPICheckMode()) {
                        this.testableMCBuilder.setBuildMode(MemberCollectionBuilder.BuildMode.TESTABLE);
                        this.testableMCBuilder.setSecondClassHierarchy(this.signatureClassesHierarchy);
                    }
                    this.testableMCBuilder.createMembers(found, this.addInherited(), true, false);
                    Filter f = PluginAPI.BEFORE_TEST.getFilter();
                    if (f != null && !f.accept(found)) {
                        return this.passed();
                    }
                    Transformer t = PluginAPI.BEFORE_TEST.getTransformer();
                    if (t != null) {
                        t.transform(found);
                    }
                    if (this.isThrowsRemoved) {
                        required.removeThrows();
                        found.removeThrows();
                    } else {
                        this.normalizer.normThrows(found, true, this.isAPICheckMode());
                        if (this.isAPICheckMode() && this.normalizeReq()) {
                            this.normalizer.normThrows(required, true, true);
                        }
                    }
                    if (this.useErasurator()) {
                        found = this.erasurator.erasure(found);
                    } else if (FORMAT_BACKWARD.equals(this.outFormat) && !this.hasClassParameter(required) && this.hasClassParameter(found)) {
                        found = this.erasurator.erasure(found);
                        required = this.erasurator.erasure(required);
                    }
                    if (!supportNSC) {
                        this.correctConstants(found);
                    }
                    this.verifyClass(required, found);
                } else {
                    this.getErrorManager().addError(MessageType.MISS_CLASSES, name, MemberType.CLASS, null, required);
                }
            }
            catch (SuperClassesNotFoundException ex) {
                String[] names;
                if (bo.isSet(Option.DEBUG)) {
                    SwissKnife.reportThrowable(ex);
                }
                for (String name1 : names = ex.getMissedClasses()) {
                    this.getErrorManager().addError(MessageType.MISS_SUPERCLASSES, name1, MemberType.CLASS, ex.getClassName(), required);
                }
            }
            catch (ClassNotFoundException ex) {
                if (bo.isSet(Option.DEBUG)) {
                    SwissKnife.reportThrowable(ex);
                }
                this.getErrorManager().addError(MessageType.MISS_CLASSES, name, MemberType.CLASS, null, required);
            }
            catch (LinkageError er) {
                if (bo.isSet(Option.DEBUG)) {
                    SwissKnife.reportThrowable(er);
                }
                this.getErrorManager().addError(MessageType.ERROR_LINKERR, name, MemberType.CLASS, i18nSt.getString("SignatureTest.mesg.linkerr.thrown", er), i18nSt.getString("SignatureTest.mesg.linkerr.notlink", name), required);
                this.trackedClassNames.add(name);
            }
            catch (ExcludeException e) {
                this.trackedClassNames.add(name);
                if (!this.isVerbose) break block22;
                this.getLog().println(i18nSt.getString("SignatureTest.mesg.verbose.verifyClass", new Object[]{name, e.getMessage()}));
                this.getLog().flush();
            }
        }
        return this.passed();
    }

    private void checkSupers(ClassDescription cl) throws SuperClassesNotFoundException {
        String[] fProblems;
        SuperInterface[] sif;
        ArrayList<String> fNotFound = new ArrayList<String>();
        SuperClass sc = cl.getSuperClass();
        ClassHierarchy hi = cl.getClassHierarchy();
        if (sc != null) {
            try {
                hi.load(sc.getQualifiedName());
            }
            catch (ClassNotFoundException ex) {
                fNotFound.add(ex.getMessage());
            }
        }
        if ((sif = cl.getInterfaces()) != null) {
            for (SuperInterface superInterface : sif) {
                try {
                    hi.load(superInterface.getQualifiedName());
                }
                catch (ClassNotFoundException ex) {
                    fNotFound.add(ex.getMessage());
                }
            }
        }
        if ((fProblems = fNotFound.toArray(new String[0])).length > 0) {
            throw new SuperClassesNotFoundException(fProblems, cl.getQualifiedName());
        }
    }

    private boolean hasClassParameter(ClassDescription cl) {
        boolean result;
        String tp = cl.getTypeParameters();
        boolean bl = result = tp != null && !tp.isEmpty();
        if (!result) {
            Iterator<MemberDescription> e = cl.getMembersIterator();
            while (e.hasNext()) {
                MemberDescription mr = e.next();
                String tpM = mr.getTypeParameters();
                if (tpM == null || tpM.isEmpty()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void verifyMduleOrPackageInfo(ClassDescription required) {
        assert (isTigerFeaturesTracked);
        String name = required.getQualifiedName();
        if (!this.isPackageMember(name)) {
            return;
        }
        this.trackedClassNames.add(name);
        ClassDescription found = null;
        try {
            found = this.testableHierarchy.load(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkAnnotations(required, found, null, null, this.signatureClassesHierarchy, this.testableHierarchy);
    }

    private void excluded(ClassDescription testedClass, MemberDescription md) throws ExcludeException {
        if (md != null && (md.isField() || md.isMethod() || md.isConstructor() || md.isInner())) {
            this.exclude.check(testedClass, md);
        }
    }

    protected void verifyClass(ClassDescription required, ClassDescription found) {
        this.trackedClassNames.add(found.getQualifiedName());
        if (this.getErrorManager() instanceof SortedErrorFormatter) {
            ((SortedErrorFormatter)this.getErrorManager()).tested(found);
        }
        this.correctClassModifiers(required, found);
        this.checkClassDescription(required, found);
        Iterator<MemberDescription> e = required.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription requiredMember = e.next();
            try {
                this.excluded(required, requiredMember);
                this.trackMember(required, found, requiredMember, found.findMember(requiredMember));
            }
            catch (ExcludeException e1) {
                if (!this.isVerbose) continue;
                this.getLog().println(i18nSt.getString("SignatureTest.mesg.verbose.verifyMember", new Object[]{required.getQualifiedName(), requiredMember.toString(), e1.getMessage()}));
                this.getLog().flush();
            }
        }
        if (!this.isSupersettingEnabled) {
            e = found.getMembersIterator();
            while (e.hasNext()) {
                MemberDescription foundMember = e.next();
                if (required.containsMember(foundMember)) continue;
                try {
                    this.excluded(found, foundMember);
                    this.trackMember(required, found, null, foundMember);
                }
                catch (ExcludeException e1) {
                    if (!this.isVerbose) continue;
                    this.getLog().println(i18nSt.getString("SignatureTest.mesg.verbose.verifyMember2", new Object[]{found.getQualifiedName(), foundMember.toString(), e1.getMessage()}));
                    this.getLog().flush();
                }
            }
        }
    }

    private void correctClassModifiers(ClassDescription required, ClassDescription found) {
        if (this.secure.checkName(found.getQualifiedName()) && required.isAbstract() != found.isAbstract() && !SwissKnife.canBeSubclassed(found) && !SwissKnife.canBeSubclassed(required)) {
            found.addModifier(Modifier.ABSTRACT);
            required.addModifier(Modifier.ABSTRACT);
        }
        if (required.hasModifier(Modifier.ENUM) && found.hasModifier(Modifier.ENUM)) {
            this.fixEnum(required);
            this.fixEnum(found);
        }
    }

    private void fixEnum(ClassDescription required) {
        required.addModifier(Modifier.FINAL);
        required.removeModifier(Modifier.ABSTRACT);
        for (MethodDescr mr : required.getDeclaredMethods()) {
            mr.addModifier(Modifier.FINAL);
            mr.removeModifier(Modifier.ABSTRACT);
        }
    }

    private void checkClassDescription(ClassDescription required, ClassDescription found) {
        this.checkAnnotations(required, found, null, null, this.signatureClassesHierarchy, this.testableHierarchy);
        if (!required.isCompatible(found)) {
            this.getErrorManager().addError(MessageType.MISS_CLASSES, required.getQualifiedName(), MemberType.CLASS, required.toString(), required);
            this.getErrorManager().addError(MessageType.ADD_CLASSES, found.getQualifiedName(), MemberType.CLASS, found.toString(), found);
        }
    }

    private MemberDescription transformMember(ClassDescription parent, MemberDescription member) {
        MemberDescription clonedMember = member;
        if (parent.hasModifier(Modifier.FINAL) && member.isMethod() && member.getDeclaringClassName().equals(parent.getQualifiedName())) {
            MethodDescr md = (MethodDescr)member;
            try {
                if (!member.hasModifier(Modifier.FINAL)) {
                    if (!this.testableHierarchy.isMethodOverriden(md)) {
                        clonedMember = (MemberDescription)member.clone();
                        clonedMember.addModifier(Modifier.FINAL);
                    }
                } else if (this.testableHierarchy.isMethodOverriden(md)) {
                    clonedMember = (MemberDescription)member.clone();
                    clonedMember.removeModifier(Modifier.FINAL);
                }
            }
            catch (ClassNotFoundException e) {
                SwissKnife.reportThrowable(e);
            }
        }
        if (BINARY_MODE.equals(this.mode) && member.isMethod() && member.hasModifier(Modifier.STATIC) && member.hasModifier(Modifier.FINAL)) {
            clonedMember = (MemberDescription)member.clone();
            clonedMember.removeModifier(Modifier.FINAL);
        }
        return clonedMember;
    }

    private void trackMember(ClassDescription parentReq, ClassDescription parentFou, MemberDescription required, MemberDescription found) {
        String name = parentReq.getQualifiedName();
        if (required != null) {
            required = this.transformMember(parentReq, required);
        }
        if (found != null) {
            found = this.transformMember(parentFou, found);
        }
        if (required != null && found != null) {
            this.transformPair(parentReq, required, parentFou, found);
            this.checkAnnotations(required, found, parentReq, parentFou, this.signatureClassesHierarchy, this.testableHierarchy);
            if (required.isCompatible(found)) {
                return;
            }
            if (this.isOneWayConstantChecking && required.isField()) {
                assert (found.isField());
                String rConstValue = ((FieldDescr)required).getConstantValue();
                String fConstValue = ((FieldDescr)found).getConstantValue();
                if (rConstValue == null && fConstValue != null && ((FieldDescr)required).isCompatible(found, true)) {
                    return;
                }
                if (fConstValue == null && rConstValue != null && ((FieldDescr)required).isCompatible(found, true)) {
                    return;
                }
            }
        }
        if (required != null) {
            this.getErrorManager().addError(MessageType.getMissingMessageType(required.getMemberType()), name, required.getMemberType(), required.toString(), required);
        }
        if (!this.isSupersettingEnabled && !this.getComponentName().equals("ApiCheck") && found != null) {
            this.getErrorManager().addError(MessageType.getAddedMessageType(found.getMemberType()), name, found.getMemberType(), found.toString(), found);
        }
    }

    private void checkAnnotations(MemberDescription base, MemberDescription test, ClassDescription baseCl, ClassDescription testCl, ClassHierarchy baseCh, ClassHierarchy testCh) {
        BaseOptions bo;
        AnnotationItem[] testAnnotList;
        if (!isTigerFeaturesTracked) {
            return;
        }
        AnnotationItem[] baseAnnotList = base == null ? AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY : this.removeUndocumentedAnnotations(base.getAnnoList(), this.signatureClassesHierarchy);
        AnnotationItem[] annotationItemArray = testAnnotList = test == null ? AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY : this.removeUndocumentedAnnotations(test.getAnnoList(), this.testableHierarchy);
        if (baseCh != null) {
            baseAnnotList = this.unpackContainerAnnotations(baseAnnotList, baseCh);
            this.normalizeArrayParaemeters(baseAnnotList, this.orderImportant, baseCh);
        }
        if (testCh != null) {
            testAnnotList = this.unpackContainerAnnotations(testAnnotList, testCh);
            this.normalizeArrayParaemeters(testAnnotList, this.orderImportant, testCh);
        }
        if (!(bo = AppContext.getContext().getBean(BaseOptions.class)).isSet(Option.STATIC)) {
            baseAnnotList = this.removeExtendedAnnotations(baseAnnotList);
        }
        if (baseAnnotList.length == 0 && testAnnotList.length == 0) {
            return;
        }
        int bl = baseAnnotList.length;
        int tl = testAnnotList.length;
        int bPos = 0;
        int tPos = 0;
        while (bPos < bl && tPos < tl) {
            int comp = baseAnnotList[bPos].compareTo(testAnnotList[tPos]);
            if (comp < 0) {
                this.reportError(baseCl, base, baseAnnotList[bPos].toString(), false);
                ++bPos;
                continue;
            }
            if (comp > 0) {
                this.reportError(testCl, test, testAnnotList[tPos].toString(), true);
                ++tPos;
                continue;
            }
            ++tPos;
            ++bPos;
        }
        while (bPos < bl) {
            this.reportError(baseCl, base, baseAnnotList[bPos].toString(), false);
            ++bPos;
        }
        while (tPos < tl) {
            this.reportError(testCl, test, testAnnotList[tPos].toString(), true);
            ++tPos;
        }
    }

    private AnnotationItem[] removeExtendedAnnotations(AnnotationItem[] baseAnnotList) {
        if (baseAnnotList == null) {
            return AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        }
        ArrayList<AnnotationItem> list = new ArrayList<AnnotationItem>(Arrays.asList(baseAnnotList));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof AnnotationItemEx)) continue;
            it.remove();
        }
        return list.toArray(AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY);
    }

    private void reportError(ClassDescription fromClass, MemberDescription fid, String anno, boolean added) {
        if (fid != null) {
            String defenition;
            String className;
            MessageType mt;
            MessageType messageType = mt = added ? MessageType.ADD_ANNO : MessageType.MISS_ANNO;
            if (fromClass == null) {
                className = fid.getQualifiedName();
                defenition = anno;
            } else {
                className = fromClass.getQualifiedName();
                defenition = fid.isMethod() ? ((MethodDescr)fid).getSignature() + ":" + anno : fid.getName() + ":" + anno;
            }
            this.getErrorManager().addError(mt, className, fid.getMemberType(), defenition, fid);
        }
    }

    protected boolean prepareCheck(MultipleFileReader in, PrintWriter log) {
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        if (this.isValueTracked == null) {
            this.isValueTracked = Boolean.TRUE;
        }
        if (EXT_MODE.equals(this.mode)) {
            Modifier.VOLATILE.setTracked(true);
        } else {
            Modifier.VOLATILE.setTracked(false);
        }
        if (this.mode == null) {
            this.mode = SOURCE_MODE;
        }
        MemberType.setMode(BINARY_MODE.equals(this.mode));
        boolean bl = this.isOneWayConstantChecking = this.isValueTracked != false && BINARY_MODE.equals(this.mode) || !bo.isSet(Option.STATIC);
        if (SOURCE_MODE.equals(this.mode) || EXT_MODE.equals(this.mode)) {
            this.isThrowsRemoved = false;
        }
        if (BINARY_MODE.equals(this.mode)) {
            this.isThrowsRemoved = true;
        }
        MemberType.setMode(BINARY_MODE.equals(this.mode));
        if (this.isValueTracked.booleanValue() && !in.isFeatureSupported(FeaturesHolder.ConstInfo)) {
            String errmsg = i18nSt.getString("SignatureTest.mesg.sigfile.noconst");
            log.println(errmsg);
            return this.failed(errmsg);
        }
        if (!in.isFeatureSupported(FeaturesHolder.ConstInfo)) {
            this.isValueTracked = Boolean.FALSE;
        }
        this.setConstantValuesTracked(this.isValueTracked);
        FieldDescr.setConstantValuesTracked(this.isConstantValuesTracked());
        log.println(i18nSt.getString("SignatureTest.mesg.sigtest.report"));
        log.println(i18nSt.getString("SignatureTest.mesg.sigtest.basevers", in.getApiVersion()));
        log.println(i18nSt.getString("SignatureTest.mesg.sigtest.testvers", this.apiVersion));
        if (!this.isThrowsRemoved) {
            log.println(i18nSt.getString("SignatureTest.mesg.sigtest.checkmode.norm", this.mode));
        } else {
            log.println(i18nSt.getString("SignatureTest.mesg.sigtest.checkmode.removed", this.mode));
        }
        if (this.isValueTracked.booleanValue()) {
            log.println(i18nSt.getString("SignatureTest.mesg.sigtest.constcheck", i18nSt.getString("SignatureTest.mesg.sigtest.constcheck.on")));
        } else {
            log.println(i18nSt.getString("SignatureTest.mesg.sigtest.constcheck", i18nSt.getString("SignatureTest.mesg.sigtest.constcheck.off")));
        }
        if (!isTigerFeaturesTracked) {
            log.println(i18nSt.getString("SignatureTest.mesg.sigtest.tigercheck"));
        }
        log.println();
        this.getClasspath().printErrors(log);
        this.trackedClassNames = new HashSet<String>();
        ClassDescriptionLoader loader = this.getClassDescrLoader();
        this.setupLoaders(loader, in);
        loader = this.getClassDescrLoader();
        AppContext.getContext().setClassLoader(loader);
        if (!this.isValueTracked.booleanValue() && loader instanceof LoadingHints) {
            ((LoadingHints)((Object)loader)).addLoadingHint(LoadingHints.DONT_READ_VALUES);
        }
        this.testableHierarchy = new ClassHierarchyImpl(loader);
        this.testableMCBuilder = new MemberCollectionBuilder(this, "source:testable");
        this.signatureClassesHierarchy = new ClassHierarchyImpl(in);
        if (FORMAT_PLAIN.equals(this.outFormat)) {
            this.setErrorManager(new ErrorFormatter(log));
        } else if (FORMAT_HUMAN.equals(this.outFormat)) {
            this.setErrorManager(new HumanErrorFormatter(log, this.isVerbose, this.reportWarningAsError ? Level.WARNING : Level.SEVERE));
        } else if (FORMAT_BACKWARD.equals(this.outFormat)) {
            this.setErrorManager(new BCProcessor(log, this.isVerbose, BINARY_MODE.equals(this.mode), this.testableHierarchy, this.signatureClassesHierarchy, this.reportWarningAsError ? Level.WARNING : Level.SEVERE, this.extensibleInterfaces));
        } else {
            this.setErrorManager(new SortedErrorFormatter(log, this.isVerbose));
        }
        return true;
    }

    static class DefaultExcludeList
    implements Exclude {
        @Override
        public void check(ClassDescription testedClassName, MemberDescription signature) throws ExcludeException {
        }

        @Override
        public String[] parseParameters(String[] args) {
            return args;
        }

        @Override
        public String report() {
            return null;
        }
    }

    static class SuperClassesNotFoundException
    extends ClassNotFoundException {
        private String[] scNames;
        private String clName;

        private SuperClassesNotFoundException(String[] scNames, String clName) {
            if (scNames == null || scNames.length == 0) {
                throw new IllegalArgumentException("Superclass list can not be empty");
            }
            this.clName = clName;
            this.scNames = scNames;
        }

        @Override
        public String getMessage() {
            if (this.scNames.length == 1) {
                return "Superclass " + this.scNames[0] + " of class " + this.clName + " not found";
            }
            StringBuffer sb = new StringBuffer("[");
            for (int i = 0; i < this.scNames.length; ++i) {
                sb.append(this.scNames[i]);
                if (i == this.scNames.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return "Superclasses " + sb + " of class " + this.clName + " not found";
        }

        private String getClassName() {
            return this.clName;
        }

        private String[] getMissedClasses() {
            return this.scNames;
        }
    }
}

