/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.Platform.anno;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.spec.Platform.anno.AnnotationTestBeanInterface;
import jakarta.ejb.EJBException;
import jakarta.ejb.Local;
import jakarta.ejb.Stateless;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.junit.jupiter.api.Assertions;

@Local(value={AnnotationTestBeanInterface.class})
@Stateless
public class AnnotationTestBean
implements AnnotationTestBeanInterface {
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);

    @Override
    public void testAnnotationDefinesManagedScheduledExecutor() {
        try {
            LinkedBlockingQueue started = new LinkedBlockingQueue();
            CountDownLatch taskCanEnd = new CountDownLatch(1);
            Callable<String> task = () -> {
                started.add(IntContext.get());
                Assertions.assertTrue((boolean)taskCanEnd.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
                return StringContext.get();
            };
            ManagedScheduledExecutorService executor = (ManagedScheduledExecutorService)InitialContext.doLookup("java:app/concurrent/ScheduledExecutorE");
            IntContext.set(3000);
            StringContext.set("testAnnotationDefinesManagedScheduledExecutor-1");
            Future future1 = executor.submit(task);
            StringContext.set("testAnnotationDefinesManagedScheduledExecutor-2");
            Future future2 = executor.submit(task);
            StringContext.set("testAnnotationDefinesManagedScheduledExecutor-3");
            Future future3 = executor.submit(task);
            StringContext.set("testAnnotationDefinesManagedScheduledExecutor-4");
            Assertions.assertEquals((Integer)0, (Integer)((Integer)started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)));
            Assertions.assertEquals((Integer)0, (Integer)((Integer)started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)));
            Assertions.assertEquals(null, (Integer)((Integer)started.poll(1L, TimeUnit.SECONDS)));
            taskCanEnd.countDown();
            Assertions.assertEquals((Object)"testAnnotationDefinesManagedScheduledExecutor-1", future1.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)"testAnnotationDefinesManagedScheduledExecutor-2", future2.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)"testAnnotationDefinesManagedScheduledExecutor-3", future3.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Integer)0, (Integer)((Integer)started.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException | NamingException x) {
            throw new EJBException(x);
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    @Override
    public void testAnnotationDefinesManagedThreadFactory() {
        try {
            IntContext.set(4000);
            StringContext.set("testAnnotationDefinesManagedThreadFactory-1");
            ManagedThreadFactory threadFactory = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryE");
            StringContext.set("testAnnotationDefinesManagedThreadFactory-2");
            LinkedBlockingQueue results = new LinkedBlockingQueue();
            Thread thread = threadFactory.newThread(() -> {
                results.add(Thread.currentThread().getPriority());
                results.add(IntContext.get());
                results.add(StringContext.get());
                try {
                    results.add(InitialContext.doLookup("java:app/concurrent/ThreadFactoryE"));
                }
                catch (Exception x) {
                    results.add(x);
                }
            });
            Assertions.assertEquals((int)6, (int)thread.getPriority());
            thread.start();
            Assertions.assertEquals((Object)6, results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)0, results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)"testAnnotationDefinesManagedThreadFactory-1", results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS));
            Object lookupResult = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            if (lookupResult instanceof Exception) {
                throw new EJBException((Exception)lookupResult);
            }
            Assertions.assertNotNull(lookupResult);
        }
        catch (InterruptedException | NamingException x) {
            throw new EJBException(x);
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }
}

