/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.discovery.implicit;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.discovery.implicit.Bar;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0")
public class ImplicitBeanArchiveSETest
extends Arquillian {
    private static final String IMPLICIT_SCAN_KEY = "javax.enterprise.inject.scan.implicit";

    @Deployment
    public static Archive<?> deployment() {
        JavaArchive implicitArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{ImplicitBeanArchiveSETest.class, Bar.class});
        return ClassPath.builder().add(implicitArchive).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_archive_se", id="b"), @SpecAssertion(section="se_bootstrap", id="dj")})
    public void testImplicitArchiveDiscovered() {
        try (SeContainer seContainer = SeContainerInitializer.newInstance().addProperty(IMPLICIT_SCAN_KEY, (Object)true).initialize();){
            Bar bar = (Bar)seContainer.select(Bar.class, new Annotation[0]).get();
            Assert.assertNotNull((Object)bar);
            bar.ping();
        }
    }
}

