/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injectionpoint.non.contextual;

import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.non.contextual.Bar;
import org.jboss.cdi.tck.tests.lookup.injectionpoint.non.contextual.Baz;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class NonContextualInjectionPointTest
extends AbstractTest {
    @Inject
    private Instance<Baz> baz;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NonContextualInjectionPointTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="injection_point", id="aaa")
    public void testNonContextualEjbInjectionPointGetBean() throws Exception {
        Bar bar = (Bar)new InitialContext().lookup("java:module/Bar");
        Bean bean = bar.getFoo().getInjectionPoint().getBean();
        Assert.assertNull((Object)bean);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="injection_point", id="aa")
    public void testContextualEjbInjectionPointGetBean() throws Exception {
        Bean bean = ((Baz)this.baz.get()).getFoo().getInjectionPoint().getBean();
        Assert.assertNotNull((Object)bean);
        Assert.assertEquals((Object)bean.getBeanClass(), Baz.class);
    }
}

