/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import jakarta.validation.Validator;
import jakarta.validation.constraints.Size;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class SizeConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)SizeConstraintTest.webArchiveBuilder().withTestClass(SizeConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-size", id="a")})
    public void testSizeConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        SizeDummyEntity dummy = new SizeDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        dummy.collection = new HashSet();
        dummy.collection.add("foo");
        dummy.collection.add("bar");
        dummy.string = "";
        dummy.map = new HashMap();
        dummy.map.put("key1", "value1");
        dummy.map.put("key2", "value2");
        SizeDummyEntity.access$402(dummy, new Integer[0]);
        SizeDummyEntity.access$502(dummy, new boolean[0]);
        SizeDummyEntity.access$602(dummy, new byte[0]);
        SizeDummyEntity.access$702(dummy, new char[0]);
        SizeDummyEntity.access$802(dummy, new double[0]);
        SizeDummyEntity.access$902(dummy, new float[0]);
        SizeDummyEntity.access$1002(dummy, new int[0]);
        SizeDummyEntity.access$1102(dummy, new long[0]);
        SizeDummyEntity.access$1202(dummy, new short[0]);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withProperty("collection"), ConstraintViolationAssert.violationOf(Size.class).withProperty("map"), ConstraintViolationAssert.violationOf(Size.class).withProperty("string"), ConstraintViolationAssert.violationOf(Size.class).withProperty("integerArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("booleanArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("byteArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("charArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("doubleArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("floatArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("intArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("longArray"), ConstraintViolationAssert.violationOf(Size.class).withProperty("shortArray"));
        dummy.collection.remove("bar");
        dummy.string = "a";
        SizeDummyEntity.access$402(dummy, new Integer[1]);
        SizeDummyEntity.access$502(dummy, new boolean[1]);
        SizeDummyEntity.access$602(dummy, new byte[1]);
        SizeDummyEntity.access$702(dummy, new char[1]);
        SizeDummyEntity.access$802(dummy, new double[1]);
        SizeDummyEntity.access$902(dummy, new float[1]);
        SizeDummyEntity.access$1002(dummy, new int[1]);
        SizeDummyEntity.access$1102(dummy, new long[1]);
        SizeDummyEntity.access$1202(dummy, new short[1]);
        dummy.map.remove("key1");
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    private static class SizeDummyEntity {
        @Size(min=1, max=1)
        private @Size(min=1, max=1) String string;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) Collection<String> collection;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) Map<String, String> map;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) Integer[] integerArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) boolean[] booleanArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) byte[] byteArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) char[] charArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) double[] doubleArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) float[] floatArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) int[] intArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) long[] longArray;
        @Size(min=1, max=1)
        private @Size(min=1, max=1) short[] shortArray;

        private SizeDummyEntity() {
        }

        static /* synthetic */ Integer[] access$402(SizeDummyEntity x0, Integer[] x1) {
            x0.integerArray = x1;
            return x1;
        }

        static /* synthetic */ boolean[] access$502(SizeDummyEntity x0, boolean[] x1) {
            x0.booleanArray = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$602(SizeDummyEntity x0, byte[] x1) {
            x0.byteArray = x1;
            return x1;
        }

        static /* synthetic */ char[] access$702(SizeDummyEntity x0, char[] x1) {
            x0.charArray = x1;
            return x1;
        }

        static /* synthetic */ double[] access$802(SizeDummyEntity x0, double[] x1) {
            x0.doubleArray = x1;
            return x1;
        }

        static /* synthetic */ float[] access$902(SizeDummyEntity x0, float[] x1) {
            x0.floatArray = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1002(SizeDummyEntity x0, int[] x1) {
            x0.intArray = x1;
            return x1;
        }

        static /* synthetic */ long[] access$1102(SizeDummyEntity x0, long[] x1) {
            x0.longArray = x1;
            return x1;
        }

        static /* synthetic */ short[] access$1202(SizeDummyEntity x0, short[] x1) {
            x0.shortArray = x1;
            return x1;
        }
    }
}

