/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration;

import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.ConfigurationDefinedConstraintValidatorFactoryResolver;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.CreditCard;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.Optional;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.User;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.XmlDefinedConstraintValidatorFactory;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ConstraintValidatorFactorySpecifiedInValidationXmlTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ConstraintValidatorFactorySpecifiedInValidationXmlTest.webArchiveBuilder().withTestClass(ConstraintValidatorFactorySpecifiedInValidationXmlTest.class)).withClasses(User.class, Optional.class, CreditCard.class, ConfigurationDefinedConstraintValidatorFactoryResolver.class, XmlDefinedConstraintValidatorFactory.class)).withValidationXml("validation-ConstraintValidatorFactorySpecifiedInValidationXmlTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="h")
    public void testConstraintValidatorFactorySpecifiedInValidationXml() {
        try {
            Validator validator = TestUtil.getValidatorUnderTest();
            validator.validate((Object)new User(), new Class[0]);
        }
        catch (ValidationException e) {
            Assert.assertTrue((XmlDefinedConstraintValidatorFactory.numberOfIsReachableCalls > 0 ? 1 : 0) != 0, (String)"The factory should have been called at least once if it was properly picked up by xml configuration.");
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="h"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="g")})
    public void testConstraintValidatorFactorySpecifiedInValidationXmlCanBeOverridden() {
        try {
            Configuration configuration = Validation.byDefaultProvider().configure();
            configuration = configuration.constraintValidatorFactory((ConstraintValidatorFactory)new ConfigurationDefinedConstraintValidatorFactoryResolver());
            Validator validator = configuration.buildValidatorFactory().getValidator();
            validator.validate((Object)new User(), new Class[0]);
        }
        catch (ValidationException e) {
            Assert.assertTrue((ConfigurationDefinedConstraintValidatorFactoryResolver.numberOfIsReachableCalls > 0 ? 1 : 0) != 0, (String)"The factory  should have been called at least once if configuration settings were applied.");
        }
    }
}

