/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import javax.validation.Validator;
import javax.validation.constraints.Digits;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class DigitsConstraintTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)DigitsConstraintTest.webArchiveBuilder().withTestClass(DigitsConstraintTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-digits", id="a")})
    public void testDigitsConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        DigitsDummyEntity dummy = new DigitsDummyEntity();
        dummy.intPrimitive = 42;
        dummy.longPrimitive = 42L;
        dummy.bytePrimitive = (byte)42;
        dummy.shortPrimitive = (short)42;
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 4);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("bytePrimitive"), ConstraintViolationAssert.pathWith().property("intPrimitive"), ConstraintViolationAssert.pathWith().property("longPrimitive"), ConstraintViolationAssert.pathWith().property("shortPrimitive"));
        dummy.intPrimitive = 1;
        dummy.longPrimitive = 1L;
        dummy.bytePrimitive = (byte)1;
        dummy.shortPrimitive = (short)1;
        dummy.intObject = Integer.valueOf("102");
        dummy.longObject = Long.valueOf("12345");
        dummy.byteObject = Byte.parseByte("111");
        dummy.shortObject = Short.parseShort("1234");
        dummy.bigDecimal = BigDecimal.valueOf(102L);
        dummy.bigInteger = BigInteger.valueOf(102L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 6);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("byteObject"), ConstraintViolationAssert.pathWith().property("intObject"), ConstraintViolationAssert.pathWith().property("longObject"), ConstraintViolationAssert.pathWith().property("shortObject"), ConstraintViolationAssert.pathWith().property("bigDecimal"), ConstraintViolationAssert.pathWith().property("bigInteger"));
        dummy.intObject = Integer.valueOf("1");
        dummy.longObject = Long.valueOf("1");
        dummy.byteObject = Byte.parseByte("1");
        dummy.shortObject = Short.parseShort("1");
        dummy.bigDecimal = BigDecimal.valueOf(1.93);
        dummy.bigInteger = BigInteger.valueOf(5L);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNumberOfViolations(constraintViolations, 0);
    }

    private static class DigitsDummyEntity {
        @Digits(integer=1, fraction=2)
        private @Digits(integer=1, fraction=2) BigDecimal bigDecimal;
        @Digits(integer=1, fraction=0)
        private @Digits(integer=1, fraction=0) BigInteger bigInteger;
        @Digits(integer=1, fraction=0)
        private @Digits(integer=1, fraction=0) byte bytePrimitive;
        @Digits(integer=1, fraction=0)
        private @Digits(integer=1, fraction=0) short shortPrimitive;
        @Digits(integer=1, fraction=0)
        private @Digits(integer=1, fraction=0) int intPrimitive;
        @Digits(integer=1, fraction=0)
        private @Digits(integer=1, fraction=0) long longPrimitive;
        @Digits(integer=1, fraction=0)
        private @Digits(integer=1, fraction=0) Byte byteObject;
        @Digits(integer=1, fraction=0)
        private @Digits(integer=1, fraction=0) Short shortObject;
        @Digits(integer=1, fraction=0)
        private @Digits(integer=1, fraction=0) Integer intObject;
        @Digits(integer=1, fraction=0)
        private @Digits(integer=1, fraction=0) Long longObject;

        private DigitsDummyEntity() {
        }
    }
}

