/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.artifacts.specialized.BatchletUsingStepContextImpl;
import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import java.util.logging.Logger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExecuteTests
extends BaseJUnit5Test {
    private static final Logger logger = Logger.getLogger(ExecuteTests.class.getName());
    private static JobOperatorBridge jobOp = null;

    @BeforeEach
    public void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @Test
    public void testMyStepContextBatchlet() throws Exception {
        String METHOD = "testMyStepContextBatchlet";
        try {
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("test_batchlet_stepCtx");
            Reporter.log((String)("EXPECTED JobExecution getExitStatus()=" + BatchletUsingStepContextImpl.GOOD_JOB_EXIT_STATUS + "<p>"));
            Reporter.log((String)("ACTUAL JobExecution getExitStatus()=" + jobExec.getExitStatus() + "<p>"));
            Reporter.log((String)"EXPECTED JobExecution getBatchStatus()=COMPLETED<p>");
            Reporter.log((String)("ACTUAL JobExecution getBatchStatus()=" + String.valueOf(jobExec.getBatchStatus()) + "<p>"));
            AssertionUtils.assertObjEquals(BatchletUsingStepContextImpl.GOOD_JOB_EXIT_STATUS, jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            ExecuteTests.handleException(METHOD, e);
        }
    }
}

