/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MetricsTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @BeforeEach
    public void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @Test
    public void testMetricsInApp() throws Exception {
        String METHOD = "testMetricsInApp";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=40<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.chunksize=7<p>");
            Reporter.log((String)"app.commitinterval=10<p>");
            Reporter.log((String)"numberOfSkips=0<p>");
            Reporter.log((String)"ReadProcessWrite=READ<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "40");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.chunksize", "7");
            jobParams.put("app.commitinterval", "10");
            jobParams.put("numberOfSkips", "0");
            jobParams.put("ReadProcessWrite", "READ");
            jobParams.put("app.writepoints", "0,7,14,21,28,30");
            jobParams.put("app.next.writepoints", "7,14,21,28,30");
            Reporter.log((String)"Locate job XML file: testChunkMetrics.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testChunkMetrics", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing metrics", "GOOD READ METRICS RESULT", execution1.getExitStatus());
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testMetricsSkipRead() throws Exception {
        String METHOD = "testMetricsSkipRead";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"numberOfSkips=2<p>");
            Reporter.log((String)"ReadProcessWrite=READ_SKIP<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "1,3,4,12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("numberOfSkips", "4");
            jobParams.put("ReadProcessWrite", "READ_SKIP");
            Reporter.log((String)"Locate job XML file: testMetricsSkipCount.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsSkipCount", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "GOOD READ METRICS RESULT", execution1.getExitStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            Reporter.log((String)"Testing the read count for execution #1<p>");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) continue;
                Reporter.log((String)("AJM: in test, found metric: " + metrics[i].getType() + "<p>"));
                AssertionUtils.assertWithMessage("Testing the read skip count for execution #1", 4L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testMetricsSkipWrite() throws Exception {
        String METHOD = "testMetricsSkipWrite";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=1,3<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"numberOfSkips=2<p>");
            Reporter.log((String)"ReadProcessWrite=WRITE_SKIP<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("writerecord.fail", "1,3,4");
            jobParams.put("app.arraysize", "30");
            jobParams.put("numberOfSkips", "3");
            jobParams.put("ReadProcessWrite", "WRITE_SKIP");
            Reporter.log((String)"Locate job XML file: testMetricsSkipWriteCount.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsSkipWriteCount", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            Reporter.log((String)"Testing the write skip count for execution #1<p>");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIP_COUNT)) continue;
                Reporter.log((String)("AJM: in test, found metric: " + metrics[i].getType() + "<p>"));
                AssertionUtils.assertWithMessage("Testing the write skip count for execution #1", 3L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testMetricsSkipProcess() throws Exception {
        String METHOD = "testMetricsSkipProcess";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=7,13<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"numberOfSkips=2<p>");
            Reporter.log((String)"ReadProcessWrite=PROCESS<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("processrecord.fail", "7,13");
            jobParams.put("app.arraysize", "30");
            jobParams.put("numberOfSkips", "2");
            jobParams.put("ReadProcessWrite", "PROCESS");
            Reporter.log((String)"Locate job XML file: testMetricsSkipCount.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsSkipCount", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "GOOD PROCESS METRICS RESULT", execution1.getExitStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            Reporter.log((String)"Testing the read count for execution #1<p>");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) continue;
                Reporter.log((String)("AJM: in test, found metric: " + metrics[i].getType() + "<p>"));
                AssertionUtils.assertWithMessage("Testing the read count for execution #1", 2L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testReadMetric() throws Exception {
        String METHOD = "testReadMetric";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            Reporter.log((String)"readrecord.fail=40<p>");
            Reporter.log((String)"app.arraysize=30<p>");
            Reporter.log((String)"app.chunksize=7<p>");
            Reporter.log((String)"app.commitinterval=10<p>");
            Reporter.log((String)"numberOfSkips=0<p>");
            Reporter.log((String)"ReadProcessWrite=READ<p>");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "-1");
            jobParams.put("app.arraysize", "30");
            Reporter.log((String)"Locate job XML file: testChunkMetrics.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricCount", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1Metric";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            Reporter.log((String)"Testing the read count for execution #1<p>");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) continue;
                Reporter.log((String)("AJM: in test, found metric: " + metrics[i].getType() + "<p>"));
                AssertionUtils.assertWithMessage("Testing the read count for execution #1", 9L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testWriteMetric() throws Exception {
        String METHOD = "testWriteMetric";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"Locate job XML file: testChunkMetrics.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricCount", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            StepExecution step = null;
            String stepNameTest = "step1Metric";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            Reporter.log((String)"Testing the read count for execution #1<p>");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) continue;
                Reporter.log((String)("AJM: in test, found metric: " + metrics[i].getType() + "<p>"));
                AssertionUtils.assertWithMessage("Testing the write count for execution #1", 9L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testMetricsFilterCount() throws Exception {
        String METHOD = "testMetricsFilterCount";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            jobParams.put("app.processFilterItem", "3");
            Reporter.log((String)"app.processFilterItem=3<p>");
            Reporter.log((String)"Locate job XML file: testMetricsFilterCount.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsFilterCount", jobParams);
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + execution1.getExecutionId() + "<p>"));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            Object tempstep = null;
            StepExecution step = null;
            String stepNameTest = "step1FM";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            Reporter.log((String)"Testing the filter count for execution #1<p>");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.FILTER_COUNT)) continue;
                AssertionUtils.assertWithMessage("Testing the filter count for execution #1", 1L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testMetricsCommitCount() throws Exception {
        String METHOD = "testMetricsCommitCount";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            jobParams.put("app.processFilterItem", "3");
            Reporter.log((String)"app.processFilterItem=3<p>");
            Reporter.log((String)"Locate job XML file: testMetricsCommitCount.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsCommitCount", jobParams);
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + execution1.getExecutionId() + "<p>"));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            Object tempstep = null;
            StepExecution step = null;
            String stepNameTest = "step1CCM";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Metric[] metrics = step.getMetrics();
            Reporter.log((String)"Testing the commit count for execution #1<p>");
            for (int i = 0; i < metrics.length; ++i) {
                if (!metrics[i].getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) continue;
                AssertionUtils.assertWithMessage("Testing the commit count for execution #1", 4L, metrics[i].getValue());
            }
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testMetricsStepTimestamps() throws Exception {
        String METHOD = "testMetricsStepTimestamps";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            jobParams.put("app.processFilterItem", "3");
            Reporter.log((String)"app.processFilterItem=3<p>");
            Reporter.log((String)"Locate job XML file: testMetricsCommitCount.xml<p>");
            long time = System.currentTimeMillis();
            Date ts = new Date(time);
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsCommitCount", jobParams);
            Reporter.log((String)("Obtaining StepExecutions for execution id: " + execution1.getExecutionId() + "<p>"));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(execution1.getExecutionId());
            Object tempstep = null;
            StepExecution step = null;
            String stepNameTest = "step1CCM";
            for (StepExecution stepEx : stepExecutions) {
                if (!stepNameTest.equals(stepEx.getStepName())) continue;
                step = stepEx;
            }
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Reporter.log((String)("AJM: testcase start time: " + ts + "<p>"));
            Reporter.log((String)("AJM: step start time: " + step.getStartTime() + "<p>"));
            Reporter.log((String)("AJM: step end time: " + step.getEndTime() + "<p>"));
            AssertionUtils.assertWithMessage("Start time of test occurs approximately before start time of step", MetricsTests.roughlyOrdered(ts, step.getStartTime()));
            AssertionUtils.assertWithMessage("Start time of step occurs approximately before end time of step", MetricsTests.roughlyOrdered(step.getStartTime(), step.getEndTime()));
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testMetricsJobExecutionTimestamps() throws Exception {
        String METHOD = "testMetricsJobExecutionTimestamps";
        try {
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            jobParams.put("app.processFilterItem", "3");
            Reporter.log((String)"app.processFilterItem=3<p>");
            Reporter.log((String)"Locate job XML file: testMetricsCommitCount.xml<p>");
            long time = System.currentTimeMillis();
            Date ts = new Date(time);
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("testMetricsCommitCount", jobParams);
            Reporter.log((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            Reporter.log((String)("AJM: testcase start time: " + ts + "<p>"));
            Reporter.log((String)("AJM: job create time: " + execution1.getCreateTime() + "<p>"));
            Reporter.log((String)("AJM: job start time: " + execution1.getStartTime() + "<p>"));
            Reporter.log((String)("AJM: job last updated time: " + execution1.getLastUpdatedTime() + "<p>"));
            Reporter.log((String)("AJM: job end time: " + execution1.getEndTime() + "<p>"));
            AssertionUtils.assertWithMessage("Start time of test occurs approximately before create time of job", MetricsTests.roughlyOrdered(ts, execution1.getCreateTime()));
            AssertionUtils.assertWithMessage("Create time of job occurs approximately before start time of job", MetricsTests.roughlyOrdered(execution1.getCreateTime(), execution1.getStartTime()));
            AssertionUtils.assertWithMessage("Start time of job occurs approximately before end time of job", MetricsTests.roughlyOrdered(execution1.getStartTime(), execution1.getEndTime()));
            AssertionUtils.assertWithMessage("Start time of job occurs approximately before Last Updated time of job", MetricsTests.roughlyOrdered(execution1.getStartTime(), execution1.getLastUpdatedTime()));
        }
        catch (Exception e) {
            MetricsTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    private static boolean roughlyOrdered(Date d1, Date d2) {
        long time1 = d1.getTime();
        long time2 = d2.getTime();
        long diff = time2 - time1;
        return diff >= -1000L;
    }
}

