/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.AbstractBatchlet;
import jakarta.batch.api.BatchProperty;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.logging.Logger;

@Named(value="jobAttributesTestBatchlet")
public class JobAttributesTestBatchlet
extends AbstractBatchlet {
    private static final String sourceClass = JobAttributesTestBatchlet.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    public static String GOOD_EXIT_STATUS = "VERY GOOD INVOCATION";
    public static String BAD_EXIT_STATUS = "VERY BAD INVOCATION";
    @Inject
    @BatchProperty(name="execution.number")
    String executionNumberString;
    @Inject
    @BatchProperty(name="execution")
    String executionString;

    public String process() throws Exception {
        int execNum = Integer.parseInt(this.executionNumberString);
        if (execNum == 1) {
            logger.fine(sourceClass + ".process(); Purposefully failing on execution == 1");
            throw new IllegalArgumentException("Purposefully failing on execution == 1");
        }
        if (execNum == 2) {
            logger.fine(sourceClass + ".process(); Success...exit normally");
            return GOOD_EXIT_STATUS;
        }
        logger.fine(sourceClass + ".process(); Unexpected count, return bad exit status");
        return BAD_EXIT_STATUS;
    }

    public void stop() throws Exception {
        super.stop();
    }
}

