/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.NumbersReader;
import com.ibm.jbatch.tck.artifacts.chunkartifacts.RetryConnectionHelper;
import com.ibm.jbatch.tck.artifacts.chunktypes.NumbersCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.NumbersRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyParentException;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemReader;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.testng.Reporter;

@Named(value="retryReader")
public class RetryReader
extends AbstractItemReader {
    private static final String CLASSNAME = NumbersReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    protected DataSource dataSource = null;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_RETRY = 1;
    private static final int STATE_SKIP = 2;
    private static final int STATE_EXCEPTION = 3;
    private int testState = 0;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="forced.fail.count.read")
    String forcedFailCountProp;
    @Inject
    @BatchProperty(name="rollback")
    String rollbackProp;
    int forcedFailCount;
    int expectedReaderChkp = -1;
    boolean rollback;
    boolean didRetry;
    int readerIndex = 1;
    int failindex = 0;
    NumbersCheckpointData numbersCheckpoint = new NumbersCheckpointData();

    public void open(Serializable cpd) throws NamingException {
        NumbersCheckpointData numbersCheckpointData = (NumbersCheckpointData)cpd;
        this.forcedFailCount = Integer.parseInt(this.forcedFailCountProp);
        this.rollback = Boolean.parseBoolean(this.rollbackProp);
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/orderDB");
        this.initializeUserDataWithProperties();
        if (cpd != null) {
            this.readerIndex = numbersCheckpointData.getCount();
            ((Properties)this.stepCtx.getTransientUserData()).setProperty("init.checkpoint", this.readerIndex + "");
        }
    }

    public NumbersRecord readItem() throws Exception {
        NumbersRecord numbersRecord;
        int i = this.readerIndex;
        Reporter.log((String)("Reading item: " + this.readerIndex + "...<br>"));
        if (this.forcedFailCount != 0 && this.readerIndex >= this.forcedFailCount && this.testState == 0) {
            this.failindex = this.readerIndex;
            this.testState = 1;
            Reporter.log((String)"Fail on purpose NumbersRecord.readItem<p>");
            throw new MyParentException("Fail on purpose in NumbersRecord.readItem()");
        }
        if (this.forcedFailCount != 0 && this.readerIndex >= this.forcedFailCount && this.testState == 3) {
            this.failindex = this.readerIndex;
            this.testState = 2;
            this.forcedFailCount = 0;
            Reporter.log((String)"Test skip -- Fail on purpose NumbersRecord.readItem<p>");
            throw new MyParentException("Test skip -- Fail on purpose in NumbersRecord.readItem()");
        }
        if (this.testState == 1) {
            if (((Properties)this.stepCtx.getTransientUserData()).getProperty("retry.read.exception.invoked") != "true") {
                Reporter.log((String)"onRetryReadException not invoked<p>");
                throw new Exception("onRetryReadException not invoked");
            }
            Reporter.log((String)"onRetryReadException was invoked<p>");
            if (((Properties)this.stepCtx.getTransientUserData()).getProperty("retry.read.exception.match") != "true") {
                Reporter.log((String)"retryable exception does not match<p>");
                throw new Exception("retryable exception does not match");
            }
            Reporter.log((String)"Retryable exception matches<p>");
            this.testState = 3;
        } else if (this.testState == 2) {
            if (((Properties)this.stepCtx.getTransientUserData()).getProperty("skip.read.item.invoked") != "true") {
                Reporter.log((String)"onSkipReadItem not invoked<p>");
                throw new Exception("onSkipReadItem not invoked");
            }
            Reporter.log((String)"onSkipReadItem was invoked<p>");
            if (((Properties)this.stepCtx.getTransientUserData()).getProperty("skip.read.item.match") != "true") {
                Reporter.log((String)"skippable exception does not match<p>");
                throw new Exception("skippable exception does not match");
            }
            Reporter.log((String)"skippable exception matches<p>");
            this.testState = 0;
        }
        if (this.readerIndex > 20) {
            return null;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = RetryConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select item, quantity from app.numbers where item = ?");
            statement.setInt(1, this.readerIndex);
            rs = statement.executeQuery();
            int quantity = -1;
            while (rs.next()) {
                quantity = rs.getInt("quantity");
            }
            ++this.readerIndex;
            Reporter.log((String)("Read [item: " + i + " quantity: " + quantity + "]<p>"));
            numbersRecord = new NumbersRecord(i, quantity);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                RetryConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        RetryConnectionHelper.cleanupConnection(connection, rs, statement);
        return numbersRecord;
    }

    public Serializable checkpointInfo() throws Exception {
        NumbersCheckpointData _chkptData = new NumbersCheckpointData();
        _chkptData.setCount(this.readerIndex);
        ((Properties)this.stepCtx.getTransientUserData()).setProperty("checkpoint.index", Integer.toString(this.readerIndex));
        return _chkptData;
    }

    private void initializeUserDataWithProperties() {
        if (this.stepCtx.getTransientUserData() == null) {
            this.stepCtx.setTransientUserData((Object)new Properties());
        }
    }
}

