/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import java.util.Properties;
import javax.batch.operations.JobExecutionNotMostRecentException;
import org.junit.Before;
import org.testng.Reporter;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RestartNotMostRecentTests {
    private JobOperatorBridge jobOp = null;

    @Test
    @org.junit.Test
    public void testRestartNotMostRecentException() throws Exception {
        String METHOD = "testRestartNotMostRecentException";
        try {
            Reporter.log((String)"starting job");
            Properties jobParams = new Properties();
            Reporter.log((String)"execution.number=1<p>");
            jobParams.put("execution.number", "1");
            TCKJobExecutionWrapper jobExec = this.jobOp.startJobAndWaitForResult("job_attributes_restart_true_test", jobParams);
            Properties restartParams = new Properties();
            Reporter.log((String)"execution.number=2<p>");
            restartParams.put("execution.number", "2");
            this.jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartParams);
            try {
                Reporter.log((String)"Trying to execute the first job execution again.");
                this.jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), restartParams);
                AssertionUtils.assertWithMessage("It should have thrown JobExecutionNotMostRecentException", false);
            }
            catch (JobExecutionNotMostRecentException e) {
                AssertionUtils.assertWithMessage("JobExecutionNotMostRecentException thrown", true);
            }
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            RestartNotMostRecentTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    public void setup(String[] args, Properties props) throws Exception {
        String METHOD = "setup";
        try {
            this.jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            RestartNotMostRecentTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    @BeforeTest
    @Before
    public void beforeTest() throws ClassNotFoundException {
        this.jobOp = new JobOperatorBridge();
    }

    @AfterTest
    public void afterTest() {
        this.jobOp = null;
    }
}

