/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsBuilder;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluent;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.PodMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PodMetricsFluent<A extends PodMetricsFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<ContainerMetricsBuilder> containers = new ArrayList();
    private String kind;
    private ObjectMetaBuilder metadata;
    private String timestamp;
    private Duration window;
    private Map<String, Object> additionalProperties;

    public PodMetricsFluent() {
    }

    public PodMetricsFluent(PodMetrics instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodMetrics instance) {
        PodMetrics podMetrics = instance = instance != null ? instance : new PodMetrics();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withContainers(instance.getContainers());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withTimestamp(instance.getTimestamp());
            this.withWindow(instance.getWindow());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToContainers(int index, ContainerMetrics item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get("containers").add(index, builder);
            this.containers.add(index, builder);
        }
        return (A)this;
    }

    public A setToContainers(int index, ContainerMetrics item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    public A addToContainers(ContainerMetrics ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    public A addAllToContainers(Collection<ContainerMetrics> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    public A removeFromContainers(ContainerMetrics ... items) {
        if (this.containers == null) {
            return (A)this;
        }
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromContainers(Collection<ContainerMetrics> items) {
        if (this.containers == null) {
            return (A)this;
        }
        for (ContainerMetrics item : items) {
            ContainerMetricsBuilder builder = new ContainerMetricsBuilder(item);
            this._visitables.get("containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromContainers(Predicate<ContainerMetricsBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerMetricsBuilder> each = this.containers.iterator();
        Object visitables = this._visitables.get("containers");
        while (each.hasNext()) {
            ContainerMetricsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ContainerMetrics> buildContainers() {
        return this.containers != null ? PodMetricsFluent.build(this.containers) : null;
    }

    public ContainerMetrics buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public ContainerMetrics buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public ContainerMetrics buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    public ContainerMetrics buildMatchingContainer(Predicate<ContainerMetricsBuilder> predicate) {
        for (ContainerMetricsBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainer(Predicate<ContainerMetricsBuilder> predicate) {
        for (ContainerMetricsBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainers(List<ContainerMetrics> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").clear();
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (ContainerMetrics item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    public A withContainers(ContainerMetrics ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove("containers");
        }
        if (containers != null) {
            for (ContainerMetrics item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    public ContainersNested<A> addNewContainer() {
        return new ContainersNested(-1, null);
    }

    public ContainersNested<A> addNewContainerLike(ContainerMetrics item) {
        return new ContainersNested(-1, item);
    }

    public ContainersNested<A> setNewContainerLike(int index, ContainerMetrics item) {
        return new ContainersNested(index, item);
    }

    public ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    public ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editMatchingContainer(Predicate<ContainerMetricsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public A withTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return (A)this;
    }

    public boolean hasTimestamp() {
        return this.timestamp != null;
    }

    public Duration getWindow() {
        return this.window;
    }

    public A withWindow(Duration window) {
        this.window = window;
        return (A)this;
    }

    public boolean hasWindow() {
        return this.window != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodMetricsFluent that = (PodMetricsFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.containers, that.containers)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.timestamp, that.timestamp)) {
            return false;
        }
        if (!Objects.equals(this.window, that.window)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.containers, this.kind, this.metadata, this.timestamp, this.window, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.timestamp != null) {
            sb.append("timestamp:");
            sb.append(this.timestamp + ",");
        }
        if (this.window != null) {
            sb.append("window:");
            sb.append(this.window + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodMetricsFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ContainersNested<N>
    extends ContainerMetricsFluent<ContainersNested<N>>
    implements Nested<N> {
        ContainerMetricsBuilder builder;
        int index;

        ContainersNested(int index, ContainerMetrics item) {
            this.index = index;
            this.builder = new ContainerMetricsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PodMetricsFluent.this.setToContainers(this.index, this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }
}

