/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;

abstract class AbstractVariableConverter {
    private static final Pattern VAR_REF = Pattern.compile("\\$\\{\\S+\\}");

    AbstractVariableConverter() {
    }

    private void resolve(Map<String, String> environment, Map<String, String> resolvedVariables, String variableReference) {
        String variableName = variableReference.substring(2, variableReference.length() - 1);
        if (!environment.containsKey(variableName)) {
            throw new IllegalArgumentException("Environment does not contain variable with name %s".formatted(variableName));
        }
        resolvedVariables.put(variableReference, environment.get(variableName));
    }

    protected final String getResolvedValue(String stringValue, Map<String, String> environmentVariables) {
        try (Scanner scanner = new Scanner(stringValue);){
            Map resolvedValues = scanner.findAll(VAR_REF).map(MatchResult::group).collect(HashMap::new, (map, varRef) -> this.resolve(environmentVariables, (Map<String, String>)map, (String)varRef), (a, b) -> a.putAll(b));
            String result = stringValue;
            for (Map.Entry entry : resolvedValues.entrySet()) {
                result = result.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            String string = result;
            return string;
        }
    }
}

