/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.application.client;

import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import java.time.Duration;
import org.eclipse.hono.application.client.DownstreamMessage;
import org.eclipse.hono.application.client.MessageContext;
import org.eclipse.hono.util.Lifecycle;

public interface CommandSender<T extends MessageContext>
extends Lifecycle {
    default public Future<Void> sendAsyncCommand(String tenantId, String deviceId, String command, String correlationId, String replyId, Buffer data) {
        return this.sendAsyncCommand(tenantId, deviceId, command, correlationId, replyId, data, null);
    }

    default public Future<Void> sendAsyncCommand(String tenantId, String deviceId, String command, String correlationId, String replyId, Buffer data, String contentType) {
        return this.sendAsyncCommand(tenantId, deviceId, command, correlationId, replyId, data, contentType, null);
    }

    public Future<Void> sendAsyncCommand(String var1, String var2, String var3, String var4, String var5, Buffer var6, String var7, SpanContext var8);

    default public Future<Void> sendOneWayCommand(String tenantId, String deviceId, String command, Buffer data) {
        return this.sendOneWayCommand(tenantId, deviceId, command, data, null, null);
    }

    public Future<Void> sendOneWayCommand(String var1, String var2, String var3, Buffer var4, String var5, SpanContext var6);

    default public Future<DownstreamMessage<T>> sendCommand(String tenantId, String deviceId, String command, Buffer data) {
        return this.sendCommand(tenantId, deviceId, command, data, null);
    }

    default public Future<DownstreamMessage<T>> sendCommand(String tenantId, String deviceId, String command, Buffer data, String contentType) {
        return this.sendCommand(tenantId, deviceId, command, data, contentType, null, null, null);
    }

    public Future<DownstreamMessage<T>> sendCommand(String var1, String var2, String var3, Buffer var4, String var5, String var6, Duration var7, SpanContext var8);
}

