/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.ext.web.client.CachingWebClientOptions;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.impl.CachingWebClientImpl;
import io.vertx.ext.web.client.impl.cache.LocalCacheStore;
import io.vertx.ext.web.client.spi.CacheStore;

@VertxGen
public interface CachingWebClient {
    @GenIgnore(value={"permitted-type"})
    public static WebClient create(WebClient webClient) {
        return CachingWebClient.create(webClient, new LocalCacheStore());
    }

    @GenIgnore(value={"permitted-type"})
    public static WebClient create(WebClient webClient, CacheStore cacheStore) {
        return CachingWebClient.create(webClient, cacheStore, new CachingWebClientOptions());
    }

    @GenIgnore(value={"permitted-type"})
    public static WebClient create(WebClient webClient, CachingWebClientOptions options) {
        return CachingWebClient.create(webClient, new LocalCacheStore(), options);
    }

    @GenIgnore(value={"permitted-type"})
    public static WebClient create(WebClient webClient, CacheStore cacheStore, CachingWebClientOptions options) {
        return CachingWebClientImpl.wrap(webClient, cacheStore, options);
    }
}

