/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.annotations.StaticInitSafe;
import io.smallrye.config.KeyMap;
import io.smallrye.config.common.MapBackedConfigSource;
import java.util.HashMap;
import java.util.Map;

@StaticInitSafe
public class DefaultsConfigSource
extends MapBackedConfigSource {
    private final KeyMap<String> wildcards = new KeyMap();

    public DefaultsConfigSource(Map<String, String> properties, String name, int ordinal) {
        super(name, DefaultsConfigSource.filterWildcards(properties), ordinal);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().contains("*")) continue;
            this.wildcards.findOrAdd(entry.getKey()).putRootValue(entry.getValue());
        }
    }

    @Override
    public String getValue(String propertyName) {
        String value = super.getValue(propertyName);
        return value == null ? this.wildcards.findRootValue(propertyName) : value;
    }

    private static Map<String, String> filterWildcards(Map<String, String> properties) {
        HashMap<String, String> filtered = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey().contains("*")) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        return filtered;
    }
}

