/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import java.time.Duration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CacheDirective {
    private static final Pattern PATTERN_MAX_AGE = Pattern.compile("^\\s*max-age\\s*=\\s*(\\d*)\\s*$");
    private static final Pattern PATTERN_NO_CACHE = Pattern.compile("^\\s*no-cache\\s*$");
    private static final CacheDirective NO_CACHE_DIRECTIVE = new CacheDirective(true, 0L);
    private final boolean noCache;
    private final long maxAge;

    private CacheDirective(boolean noCacheFlag, long maxAge) {
        this.noCache = noCacheFlag;
        this.maxAge = maxAge;
    }

    public static CacheDirective maxAgeDirective(long maxAge) {
        if (maxAge <= 0L) {
            throw new IllegalArgumentException("max age must be > 0");
        }
        return new CacheDirective(false, maxAge);
    }

    public static CacheDirective maxAgeDirective(Duration maxAge) {
        return CacheDirective.maxAgeDirective(maxAge.toMillis() / 1000L);
    }

    public static CacheDirective noCacheDirective() {
        return NO_CACHE_DIRECTIVE;
    }

    public static CacheDirective from(String directive) {
        if (directive == null) {
            return null;
        }
        Matcher matcher = PATTERN_MAX_AGE.matcher(directive);
        if (matcher.matches()) {
            return CacheDirective.maxAgeDirective(Long.parseLong(matcher.group(1)));
        }
        matcher = PATTERN_NO_CACHE.matcher(directive);
        if (matcher.matches()) {
            return CacheDirective.noCacheDirective();
        }
        return null;
    }

    public boolean isCachingAllowed() {
        return !this.noCache;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public String toString() {
        if (this.noCache) {
            return "no-cache";
        }
        return String.format("max-age = %d", this.maxAge);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.maxAge ^ this.maxAge >>> 32);
        result = 31 * result + (this.noCache ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheDirective other = (CacheDirective)obj;
        if (this.maxAge != other.maxAge) {
            return false;
        }
        return this.noCache == other.noCache;
    }
}

