/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class UniJoinFirst<T>
extends AbstractUni<T> {
    private final List<Uni<T>> unis;
    private final Mode mode;
    private final int concurrency;

    public UniJoinFirst(List<Uni<T>> unis, Mode mode, int concurrency) {
        this.unis = unis;
        this.mode = mode;
        this.concurrency = concurrency;
        assert (mode == Mode.FIRST_WITH_ITEM || mode == Mode.FIRST_TO_EMIT && concurrency == -1);
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        UniJoinFirstSubscription joinAllSubscription = new UniJoinFirstSubscription(subscriber);
        subscriber.onSubscribe(joinAllSubscription);
        joinAllSubscription.triggerSubscriptions();
    }

    private class UniJoinFirstSubscription
    implements UniSubscription {
        private final UniSubscriber<? super T> subscriber;
        private final AtomicReferenceArray<UniSubscription> subscriptions;
        private final AtomicBoolean cancelled;
        private AtomicInteger nextSubscriptionIndex;
        private final List<Throwable> failures;

        public UniJoinFirstSubscription(UniSubscriber<? super T> subscriber) {
            this.subscriptions = new AtomicReferenceArray(UniJoinFirst.this.unis.size());
            this.cancelled = new AtomicBoolean();
            this.failures = Collections.synchronizedList(new ArrayList());
            this.subscriber = subscriber;
        }

        public void triggerSubscriptions() {
            int limit;
            if (UniJoinFirst.this.concurrency != -1) {
                limit = Math.min(UniJoinFirst.this.concurrency, UniJoinFirst.this.unis.size());
                this.nextSubscriptionIndex = new AtomicInteger(UniJoinFirst.this.concurrency - 1);
            } else {
                limit = UniJoinFirst.this.unis.size();
            }
            for (int i = 0; i < limit && this.trySubscribe(i); ++i) {
            }
        }

        private boolean trySubscribe(int index) {
            boolean proceed;
            boolean bl = proceed = !this.cancelled.get();
            if (proceed) {
                Uni uni = (Uni)UniJoinFirst.this.unis.get(index);
                uni.onSubscription().invoke(subscription -> this.onSubscribe(index, (UniSubscription)subscription)).subscribe().with(this.subscriber.context(), this::onItem, this::onFailure);
            }
            return proceed;
        }

        private void onSubscribe(int index, UniSubscription subscription) {
            if (!this.cancelled.get()) {
                this.subscriptions.set(index, subscription);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void cancel() {
            this.cancelled.set(true);
            this.cancelSubscriptions();
        }

        private void cancelSubscriptions() {
            for (int i = 0; i < UniJoinFirst.this.unis.size(); ++i) {
                UniSubscription sub = this.subscriptions.get(i);
                if (sub == null) continue;
                sub.cancel();
            }
        }

        private void onItem(T item) {
            if (this.cancelled.compareAndSet(false, true)) {
                this.cancelSubscriptions();
                this.subscriber.onItem(item);
            }
        }

        private void onFailure(Throwable failure) {
            if (this.cancelled.get()) {
                return;
            }
            switch (UniJoinFirst.this.mode) {
                case FIRST_TO_EMIT: {
                    if (!this.cancelled.compareAndSet(false, true)) break;
                    this.cancelSubscriptions();
                    this.subscriber.onFailure(failure);
                    break;
                }
                case FIRST_WITH_ITEM: {
                    int nextIndex;
                    this.failures.add(failure);
                    if (this.failures.size() == UniJoinFirst.this.unis.size()) {
                        if (!this.cancelled.compareAndSet(false, true)) break;
                        this.subscriber.onFailure(new CompositeException(this.failures));
                        break;
                    }
                    if (UniJoinFirst.this.concurrency == -1 || (nextIndex = this.nextSubscriptionIndex.incrementAndGet()) >= UniJoinFirst.this.unis.size()) break;
                    this.trySubscribe(nextIndex);
                }
            }
        }
    }

    public static enum Mode {
        FIRST_TO_EMIT,
        FIRST_WITH_ITEM;

    }
}

