/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.ConfigurationRuntimeConfig;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ExpressionConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

@Recorder
public class ConfigRecorder {
    private static final Logger log = Logger.getLogger(ConfigRecorder.class);
    final ConfigurationRuntimeConfig configurationConfig;

    public ConfigRecorder(ConfigurationRuntimeConfig configurationConfig) {
        this.configurationConfig = configurationConfig;
    }

    public void handleConfigChange(Map<String, ConfigValue> buildTimeRuntimeValues) {
        SmallRyeConfigBuilder configBuilder = ConfigUtils.emptyConfigBuilder();
        configBuilder.withDefaultValue("mp.config.property.expressions.enabled", "false");
        for (ConfigSource configSource : ConfigProvider.getConfig().getConfigSources()) {
            if ("BuildTime RunTime Fixed".equals(configSource.getName())) continue;
            configBuilder.withSources(configSource);
        }
        configBuilder.withInterceptors(new ExpressionConfigSourceInterceptor(){

            @Override
            public io.smallrye.config.ConfigValue getValue(final ConfigSourceInterceptorContext context, String name) {
                return super.getValue(new ConfigSourceInterceptorContext(){

                    @Override
                    public io.smallrye.config.ConfigValue proceed(String name) {
                        io.smallrye.config.ConfigValue configValue = context.proceed(name);
                        if (configValue == null && (configValue = (io.smallrye.config.ConfigValue)ConfigProvider.getConfig().getConfigValue(name)).getValue() == null) {
                            return null;
                        }
                        return configValue;
                    }

                    @Override
                    public Iterator<String> iterateNames() {
                        return context.iterateNames();
                    }

                    @Override
                    public Iterator<io.smallrye.config.ConfigValue> iterateValues() {
                        return context.iterateValues();
                    }
                }, name);
            }
        });
        SmallRyeConfig config = configBuilder.build();
        ArrayList<CallSite> mismatches = new ArrayList<CallSite>();
        for (Map.Entry<String, ConfigValue> entry : buildTimeRuntimeValues.entrySet()) {
            io.smallrye.config.ConfigValue currentValue = config.getConfigValue(entry.getKey());
            if (currentValue.getValue() == null || entry.getValue().getValue().equals(currentValue.getValue()) || entry.getValue().getSourceOrdinal() >= currentValue.getSourceOrdinal()) continue;
            mismatches.add((CallSite)((Object)(" - " + entry.getKey() + " is set to '" + currentValue.getValue() + "' but it is build time fixed to '" + entry.getValue().getValue() + "'. Did you change the property " + entry.getKey() + " after building the application?")));
        }
        if (!mismatches.isEmpty()) {
            String msg = "Build time property cannot be changed at runtime:\n" + String.join((CharSequence)"\n", mismatches);
            switch (this.configurationConfig.buildTimeMismatchAtRuntime) {
                case fail: {
                    throw new IllegalStateException(msg);
                }
                case warn: {
                    log.warn(msg);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected " + ConfigurationRuntimeConfig.BuildTimeMismatchAtRuntime.class.getName() + ": " + this.configurationConfig.buildTimeMismatchAtRuntime);
                }
            }
        }
    }

    public void handleNativeProfileChange(List<String> buildProfiles) {
        SmallRyeConfig config = ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        List<String> runtimeProfiles = config.getProfiles();
        if (buildProfiles.size() != runtimeProfiles.size()) {
            log.warn("The profile '" + buildProfiles + "' used to build the native image is different from the runtime profile '" + runtimeProfiles + "'. This may lead to unexpected results.");
            return;
        }
        for (int i = 0; i < buildProfiles.size(); ++i) {
            String runtimeProfile;
            String buildProfile = buildProfiles.get(i);
            if (buildProfile.equals(runtimeProfile = runtimeProfiles.get(i))) continue;
            log.warn("The profile '" + buildProfile + "' used to build the native image is different from the runtime profile '" + runtimeProfile + "'. This may lead to unexpected results.");
        }
    }
}

