/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core;

import io.netty.channel.EventLoopGroup;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.TimeoutStream;
import io.vertx.mutiny.core.WorkerExecutor;
import io.vertx.mutiny.core.datagram.DatagramSocket;
import io.vertx.mutiny.core.dns.DnsClient;
import io.vertx.mutiny.core.eventbus.EventBus;
import io.vertx.mutiny.core.file.FileSystem;
import io.vertx.mutiny.core.http.HttpClient;
import io.vertx.mutiny.core.http.HttpServer;
import io.vertx.mutiny.core.metrics.Measured;
import io.vertx.mutiny.core.net.NetClient;
import io.vertx.mutiny.core.net.NetServer;
import io.vertx.mutiny.core.shareddata.SharedData;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

@MutinyGen(value=io.vertx.core.Vertx.class)
public class Vertx
implements Measured {
    public static final TypeArg<Vertx> __TYPE_ARG = new TypeArg<Vertx>(obj -> new Vertx((io.vertx.core.Vertx)obj), Vertx::getDelegate);
    private final io.vertx.core.Vertx delegate;
    private FileSystem cached_0;
    private EventBus cached_1;
    private SharedData cached_2;
    private Boolean cached_3;

    public Vertx(io.vertx.core.Vertx delegate) {
        this.delegate = delegate;
    }

    public Vertx(Object delegate) {
        this.delegate = (io.vertx.core.Vertx)delegate;
    }

    Vertx() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.Vertx getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertx that = (Vertx)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public static Vertx vertx() {
        Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx());
        return ret;
    }

    public static Vertx vertx(VertxOptions options) {
        Vertx ret = Vertx.newInstance(io.vertx.core.Vertx.vertx(options));
        return ret;
    }

    @CheckReturnValue
    public static Uni<Vertx> clusteredVertx(VertxOptions options) {
        return AsyncResultUni.toUni(resultHandler -> io.vertx.core.Vertx.clusteredVertx(options, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)resultHandler, ar -> ar.map(event -> Vertx.newInstance(event)))));
    }

    public static Vertx clusteredVertxAndAwait(VertxOptions options) {
        return Vertx.clusteredVertx(options).await().indefinitely();
    }

    public static void clusteredVertxAndForget(VertxOptions options) {
        Vertx.clusteredVertx(options).subscribe().with(UniHelper.NOOP);
    }

    public static Context currentContext() {
        Context ret = Context.newInstance(io.vertx.core.Vertx.currentContext());
        return ret;
    }

    public Context getOrCreateContext() {
        Context ret = Context.newInstance(this.delegate.getOrCreateContext());
        return ret;
    }

    public NetServer createNetServer(NetServerOptions options) {
        NetServer ret = NetServer.newInstance(this.delegate.createNetServer(options));
        return ret;
    }

    public NetServer createNetServer() {
        NetServer ret = NetServer.newInstance(this.delegate.createNetServer());
        return ret;
    }

    public NetClient createNetClient(NetClientOptions options) {
        NetClient ret = NetClient.newInstance(this.delegate.createNetClient(options));
        return ret;
    }

    public NetClient createNetClient() {
        NetClient ret = NetClient.newInstance(this.delegate.createNetClient());
        return ret;
    }

    public HttpServer createHttpServer(HttpServerOptions options) {
        HttpServer ret = HttpServer.newInstance(this.delegate.createHttpServer(options));
        return ret;
    }

    public HttpServer createHttpServer() {
        HttpServer ret = HttpServer.newInstance(this.delegate.createHttpServer());
        return ret;
    }

    public HttpClient createHttpClient(HttpClientOptions options) {
        HttpClient ret = HttpClient.newInstance(this.delegate.createHttpClient(options));
        return ret;
    }

    public HttpClient createHttpClient() {
        HttpClient ret = HttpClient.newInstance(this.delegate.createHttpClient());
        return ret;
    }

    public DatagramSocket createDatagramSocket(DatagramSocketOptions options) {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.createDatagramSocket(options));
        return ret;
    }

    public DatagramSocket createDatagramSocket() {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.createDatagramSocket());
        return ret;
    }

    public FileSystem fileSystem() {
        FileSystem ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = FileSystem.newInstance(this.delegate.fileSystem());
        return ret;
    }

    public EventBus eventBus() {
        EventBus ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = EventBus.newInstance(this.delegate.eventBus());
        return ret;
    }

    public DnsClient createDnsClient(int port, String host) {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient(port, host));
        return ret;
    }

    public DnsClient createDnsClient() {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient());
        return ret;
    }

    public DnsClient createDnsClient(DnsClientOptions options) {
        DnsClient ret = DnsClient.newInstance(this.delegate.createDnsClient(options));
        return ret;
    }

    public SharedData sharedData() {
        SharedData ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = SharedData.newInstance(this.delegate.sharedData());
        return ret;
    }

    private long __setTimer(long delay, Handler<Long> handler) {
        long ret = this.delegate.setTimer(delay, handler);
        return ret;
    }

    public long setTimer(long delay, Consumer<Long> handler) {
        return this.__setTimer(delay, (Handler<Long>)(handler != null ? new DelegatingConsumerHandler<Long>(handler) : null));
    }

    public TimeoutStream timerStream(long delay) {
        TimeoutStream ret = TimeoutStream.newInstance(this.delegate.timerStream(delay));
        return ret;
    }

    private long __setPeriodic(long delay, Handler<Long> handler) {
        long ret = this.delegate.setPeriodic(delay, handler);
        return ret;
    }

    public long setPeriodic(long delay, Consumer<Long> handler) {
        return this.__setPeriodic(delay, (Handler<Long>)(handler != null ? new DelegatingConsumerHandler<Long>(handler) : null));
    }

    public TimeoutStream periodicStream(long delay) {
        TimeoutStream ret = TimeoutStream.newInstance(this.delegate.periodicStream(delay));
        return ret;
    }

    public boolean cancelTimer(long id) {
        boolean ret = this.delegate.cancelTimer(id);
        return ret;
    }

    private void __runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public void runOnContext(Runnable action) {
        this.__runOnContext(ignored -> action.run());
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.close((Handler<AsyncResult<Void>>)completionHandler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<String> deployVerticle(String name) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.deployVerticle(name, (Handler<AsyncResult<String>>)completionHandler));
    }

    public String deployVerticleAndAwait(String name) {
        return this.deployVerticle(name).await().indefinitely();
    }

    public void deployVerticleAndForget(String name) {
        this.deployVerticle(name).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<String> deployVerticle(String name, DeploymentOptions options) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.deployVerticle(name, options, (Handler<AsyncResult<String>>)completionHandler));
    }

    public String deployVerticleAndAwait(String name, DeploymentOptions options) {
        return this.deployVerticle(name, options).await().indefinitely();
    }

    public void deployVerticleAndForget(String name, DeploymentOptions options) {
        this.deployVerticle(name, options).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> undeploy(String deploymentID) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.undeploy(deploymentID, (Handler<AsyncResult<Void>>)completionHandler));
    }

    public Void undeployAndAwait(String deploymentID) {
        return this.undeploy(deploymentID).await().indefinitely();
    }

    public void undeployAndForget(String deploymentID) {
        this.undeploy(deploymentID).subscribe().with(UniHelper.NOOP);
    }

    public Set<String> deploymentIDs() {
        Set<String> ret = this.delegate.deploymentIDs();
        return ret;
    }

    public boolean isClustered() {
        boolean ret = this.delegate.isClustered();
        return ret;
    }

    @CheckReturnValue
    public <T> Uni<T> executeBlocking(final Uni<T> blockingCodeHandler, boolean ordered) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeBlocking(new Handler<Promise<T>>(){

            @Override
            public void handle(Promise<T> event) {
                blockingCodeHandler.subscribe().with(it -> event.complete(it), failure -> event.fail((Throwable)failure));
            }
        }, ordered, resultHandler));
    }

    public <T> T executeBlockingAndAwait(Uni<T> blockingCodeHandler, boolean ordered) {
        return this.executeBlocking(blockingCodeHandler, ordered).await().indefinitely();
    }

    public <T> void executeBlockingAndForget(Uni<T> blockingCodeHandler, boolean ordered) {
        this.executeBlocking(blockingCodeHandler, ordered).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public <T> Uni<T> executeBlocking(final Uni<T> blockingCodeHandler) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeBlocking(new Handler<Promise<T>>(){

            @Override
            public void handle(Promise<T> event) {
                blockingCodeHandler.subscribe().with(it -> event.complete(it), failure -> event.fail((Throwable)failure));
            }
        }, resultHandler));
    }

    public <T> T executeBlockingAndAwait(Uni<T> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler).await().indefinitely();
    }

    public <T> void executeBlockingAndForget(Uni<T> blockingCodeHandler) {
        this.executeBlocking(blockingCodeHandler).subscribe().with(UniHelper.NOOP);
    }

    public WorkerExecutor createSharedWorkerExecutor(String name) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name));
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name, poolSize));
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime));
        return ret;
    }

    public WorkerExecutor createSharedWorkerExecutor(String name, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        WorkerExecutor ret = WorkerExecutor.newInstance(this.delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, maxExecuteTimeUnit));
        return ret;
    }

    public boolean isNativeTransportEnabled() {
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        boolean ret = this.delegate.isNativeTransportEnabled();
        this.cached_3 = ret;
        return ret;
    }

    @Fluent
    private Vertx __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Vertx exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler<Throwable>(handler) : null));
    }

    @CheckReturnValue
    public Uni<String> deployVerticle(Verticle verticle) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.deployVerticle(verticle, (Handler<AsyncResult<String>>)completionHandler));
    }

    public String deployVerticleAndAwait(Verticle verticle) {
        return this.deployVerticle(verticle).await().indefinitely();
    }

    public void deployVerticleAndForget(Verticle verticle) {
        this.deployVerticle(verticle).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<String> deployVerticle(Verticle verticle, DeploymentOptions options) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.deployVerticle(verticle, options, (Handler<AsyncResult<String>>)completionHandler));
    }

    public String deployVerticleAndAwait(Verticle verticle, DeploymentOptions options) {
        return this.deployVerticle(verticle, options).await().indefinitely();
    }

    public void deployVerticleAndForget(Verticle verticle, DeploymentOptions options) {
        this.deployVerticle(verticle, options).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<String> deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.deployVerticle(verticleSupplier, options, (Handler<AsyncResult<String>>)completionHandler));
    }

    public String deployVerticleAndAwait(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
        return this.deployVerticle(verticleSupplier, options).await().indefinitely();
    }

    public void deployVerticleAndForget(Supplier<Verticle> verticleSupplier, DeploymentOptions options) {
        this.deployVerticle(verticleSupplier, options).subscribe().with(UniHelper.NOOP);
    }

    public void registerVerticleFactory(VerticleFactory factory) {
        this.delegate.registerVerticleFactory(factory);
    }

    public void unregisterVerticleFactory(VerticleFactory factory) {
        this.delegate.unregisterVerticleFactory(factory);
    }

    public Set<VerticleFactory> verticleFactories() {
        Set<VerticleFactory> ret = this.delegate.verticleFactories();
        return ret;
    }

    public EventLoopGroup nettyEventLoopGroup() {
        EventLoopGroup ret = this.delegate.nettyEventLoopGroup();
        return ret;
    }

    public static Vertx newInstance(io.vertx.core.Vertx arg) {
        return arg != null ? new Vertx(arg) : null;
    }
}

