/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime;

import io.quarkus.arc.impl.ParameterizedTypeImpl;
import io.quarkus.runtime.annotations.RecordableConstructor;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.ConfigProducerUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Recorder
public class ConfigRecorder {
    public void validateConfigProperties(Set<ConfigValidationMetadata> properties) {
        Config config = ConfigProvider.getConfig();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ConfigRecorder.class.getClassLoader();
        }
        HashSet<String> problems = new HashSet<String>();
        ArrayList<Exception> suppressed = new ArrayList<Exception>();
        StringBuilder msg = new StringBuilder();
        for (ConfigValidationMetadata property : properties) {
            Class<?> clazz = this.load(property.getRawTypeName(), cl);
            Object effectivePropertyType = clazz;
            if (clazz.isArray() || clazz.getTypeParameters().length > 0 && clazz != Map.class && clazz != List.class && clazz != Set.class) {
                effectivePropertyType = String.class;
            } else if (property.getActualTypeArgumentNames().size() > 0) {
                Type[] genericTypes = new Type[property.getActualTypeArgumentNames().size()];
                for (int i = 0; i < property.getActualTypeArgumentNames().size(); ++i) {
                    genericTypes[i] = this.load(property.getActualTypeArgumentNames().get(i), cl);
                }
                effectivePropertyType = new ParameterizedTypeImpl(clazz, genericTypes);
            }
            try {
                ConfigProducerUtil.getValue(property.getName(), effectivePropertyType, property.getDefaultValue(), config);
            }
            catch (Exception e) {
                msg.append("Failed to load config value of type ").append(effectivePropertyType).append(" for: ").append(property.getName());
                problems.add(property.getName());
                suppressed.add(e);
            }
        }
        if (!problems.isEmpty()) {
            DeploymentException deploymentException = new DeploymentException(new ConfigurationException(msg.toString(), problems));
            for (Throwable throwable : suppressed) {
                deploymentException.addSuppressed(throwable);
            }
            throw deploymentException;
        }
    }

    public void registerConfigMappings(Set<ConfigMappings.ConfigClassWithPrefix> configClasses) {
        try {
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
            ConfigMappings.registerConfigMappings(config, configClasses);
        }
        catch (ConfigValidationException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    public void registerConfigProperties(Set<ConfigMappings.ConfigClassWithPrefix> configClasses) {
        try {
            SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
            ConfigMappings.registerConfigProperties(config, configClasses);
        }
        catch (ConfigValidationException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    private Class<?> load(String className, ClassLoader cl) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        try {
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the config property type: " + className, e);
        }
    }

    public static class ConfigValidationMetadata {
        private String name;
        private String rawTypeName;
        private List<String> actualTypeArgumentNames;
        private String defaultValue;

        @RecordableConstructor
        public ConfigValidationMetadata(String name, String rawTypeName, List<String> actualTypeArgumentNames, String defaultValue) {
            this.name = name;
            this.rawTypeName = rawTypeName;
            this.actualTypeArgumentNames = actualTypeArgumentNames;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRawTypeName() {
            return this.rawTypeName;
        }

        public List<String> getActualTypeArgumentNames() {
            return this.actualTypeArgumentNames;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigValidationMetadata that = (ConfigValidationMetadata)o;
            return this.name.equals(that.name) && this.rawTypeName.equals(that.rawTypeName) && this.actualTypeArgumentNames.equals(that.actualTypeArgumentNames) && Objects.equals(this.defaultValue, that.defaultValue);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.rawTypeName, this.actualTypeArgumentNames, this.defaultValue);
        }
    }
}

