/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpanContext;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.BooleanTag;
import io.opentracing.tag.IntTag;
import io.opentracing.tag.StringTag;
import io.opentracing.tag.Tags;
import io.vertx.core.MultiMap;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.hono.tracing.JsonObjectExtractAdapter;
import org.eclipse.hono.tracing.JsonObjectInjectAdapter;
import org.eclipse.hono.tracing.MultiMapExtractAdapter;
import org.eclipse.hono.tracing.MultiMapInjectAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TracingHelper {
    public static final StringTag TAG_ADAPTER_INSTANCE_ID = new StringTag("adapter_instance_id");
    public static final BooleanTag TAG_AUTHENTICATED = new BooleanTag("authenticated");
    public static final StringTag TAG_AUTH_ID = new StringTag("auth_id");
    public static final BooleanTag TAG_CACHE_HIT = new BooleanTag("cache_hit");
    public static final StringTag TAG_CLIENT_ID = new StringTag("client_id");
    public static final StringTag TAG_CORRELATION_ID = new StringTag("message_bus.correlation_id");
    public static final StringTag TAG_CREDENTIALS_TYPE = new StringTag("credentials_type");
    public static final IntTag TAG_CREDIT = new IntTag("message_bus.credit");
    public static final StringTag TAG_DEVICE_ID = new StringTag("device_id");
    public static final IntTag TAG_DEVICE_TTD = new IntTag("ttd");
    public static final StringTag TAG_GATEWAY_ID = new StringTag("gateway_id");
    public static final StringTag TAG_MESSAGE_ID = new StringTag("message_bus.message_id");
    public static final StringTag TAG_PEER_CONTAINER = new StringTag("peer.container");
    public static final StringTag TAG_QOS = new StringTag("qos");
    public static final StringTag TAG_REMOTE_STATE = new StringTag("message_bus.remote_state");
    public static final StringTag TAG_RESOURCE_VERSION = new StringTag("resource_version");
    public static final StringTag TAG_SUBJECT_DN = new StringTag("subject_dn");
    public static final StringTag TAG_TENANT_ID = new StringTag("tenant_id");
    public static final BooleanTag TAG_TLS = new BooleanTag("tls");
    public static final String ERROR_CAUSE_OBJECT = "error.cause.object";
    private static final String JSON_KEY_SPAN_CONTEXT = "span-context";
    private static final Logger LOG = LoggerFactory.getLogger(TracingHelper.class);

    private TracingHelper() {
    }

    public static void setDeviceTags(io.opentracing.Span span, String tenantId, String deviceId) {
        TracingHelper.setDeviceTags(span, tenantId, deviceId, null);
    }

    public static void setDeviceTags(io.opentracing.Span span, String tenantId, String deviceId, String authId) {
        if (span != null) {
            if (tenantId != null) {
                TAG_TENANT_ID.set(span, tenantId);
            }
            if (deviceId != null) {
                TAG_DEVICE_ID.set(span, deviceId);
            }
            if (authId != null) {
                TAG_AUTH_ID.set(span, authId);
            }
        }
    }

    public static void logError(io.opentracing.Span span, Throwable error) {
        TracingHelper.logError(span, error, false);
    }

    public static void logError(io.opentracing.Span span, Throwable error, boolean skipUnexpectedErrorCheck) {
        if (!skipUnexpectedErrorCheck) {
            TracingHelper.logUnexpectedError(error, span);
        }
        if (span != null) {
            TracingHelper.logError(span, TracingHelper.getErrorLogItems(null, error));
        }
    }

    private static void logUnexpectedError(Throwable error, io.opentracing.Span span) {
        if (error instanceof NullPointerException || error instanceof IllegalArgumentException || error instanceof IllegalStateException) {
            Optional.ofNullable(span).ifPresentOrElse(s -> LOG.warn("An unexpected error occurred! [logged on trace {}, span {}]", s.context().toTraceId(), s.context().toSpanId(), error), () -> LOG.warn("An unexpected error occurred!", error));
        }
    }

    public static Map<String, Object> getErrorLogItems(String message, Throwable error) {
        HashMap<String, Object> items = new HashMap<String, Object>(4);
        items.put("event", Tags.ERROR.getKey());
        Optional.ofNullable(message).ifPresent(ok -> items.put("message", message));
        if (error != null) {
            items.put("error.object", TracingHelper.getErrorObjectFieldValue(error));
            if (error.getCause() != null) {
                items.put(ERROR_CAUSE_OBJECT, error.getCause());
            }
        }
        return items;
    }

    private static Object getErrorObjectFieldValue(Throwable error) {
        if (error.getClass().getName().startsWith("org.eclipse.hono.")) {
            return error.toString();
        }
        return error;
    }

    public static void logError(io.opentracing.Span span, String message) {
        if (span != null) {
            Objects.requireNonNull(message);
            HashMap<String, String> items = new HashMap<String, String>(2);
            items.put("message", message);
            items.put("event", Tags.ERROR.getKey());
            TracingHelper.logError(span, items);
        }
    }

    public static void logError(io.opentracing.Span span, String message, Throwable error) {
        TracingHelper.logUnexpectedError(error, span);
        if (span != null) {
            if (message == null && error == null) {
                throw new NullPointerException("Either message or error must not be null");
            }
            TracingHelper.logError(span, TracingHelper.getErrorLogItems(message, error));
        }
    }

    public static void logError(io.opentracing.Span span, Map<String, ?> items) {
        if (span != null) {
            Tags.ERROR.set(span, Boolean.TRUE);
            if (items != null && !items.isEmpty()) {
                Object event = items.get("event");
                if (event == null || !Tags.ERROR.getKey().equals(event)) {
                    HashMap<String, Object> itemsWithErrorEvent = new HashMap<String, Object>(items.size() + 1);
                    itemsWithErrorEvent.putAll(items);
                    itemsWithErrorEvent.put("event", Tags.ERROR.getKey());
                    span.log(itemsWithErrorEvent);
                } else {
                    span.log(items);
                }
            } else {
                span.log(Tags.ERROR.getKey());
            }
        }
    }

    public static void injectSpanContext(Tracer tracer, SpanContext spanContext, JsonObject jsonObject) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(jsonObject);
        if (spanContext != null && !(spanContext instanceof NoopSpanContext)) {
            JsonObject spanContextJson = new JsonObject();
            jsonObject.put(JSON_KEY_SPAN_CONTEXT, spanContextJson);
            tracer.inject(spanContext, Format.Builtin.TEXT_MAP, new JsonObjectInjectAdapter(spanContextJson));
        }
    }

    public static SpanContext extractSpanContext(Tracer tracer, JsonObject jsonObject) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(jsonObject);
        Object spanContextContainer = jsonObject.getValue(JSON_KEY_SPAN_CONTEXT);
        return spanContextContainer instanceof JsonObject ? tracer.extract(Format.Builtin.TEXT_MAP, new JsonObjectExtractAdapter((JsonObject)spanContextContainer)) : null;
    }

    public static void injectSpanContext(Tracer tracer, SpanContext spanContext, DeliveryOptions deliveryOptions) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(deliveryOptions);
        if (spanContext != null && !(spanContext instanceof NoopSpanContext)) {
            MultiMap headers = Optional.of(deliveryOptions).map(options -> options.getHeaders()).orElseGet(() -> {
                MultiMap newHeaders = MultiMap.caseInsensitiveMultiMap();
                deliveryOptions.setHeaders(newHeaders);
                return newHeaders;
            });
            tracer.inject(spanContext, Format.Builtin.TEXT_MAP, new MultiMapInjectAdapter(headers));
        }
    }

    public static SpanContext extractSpanContext(Tracer tracer, MultiMap headers) {
        Span currentOpenTelemetrySpan;
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(headers);
        if (headers.isEmpty()) {
            return null;
        }
        SpanContext spanContext = tracer.extract(Format.Builtin.TEXT_MAP, new MultiMapExtractAdapter(headers));
        if (spanContext != null && (currentOpenTelemetrySpan = Span.current()) != null && spanContext.toTraceId().equals(currentOpenTelemetrySpan.getSpanContext().getTraceId()) && spanContext.toSpanId().equals(currentOpenTelemetrySpan.getSpanContext().getSpanId())) {
            return null;
        }
        return spanContext;
    }

    public static void injectSpanContext(Tracer tracer, SpanContext spanContext, final BiConsumer<String, String> keyValueConsumer) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(keyValueConsumer);
        if (spanContext != null && !(spanContext instanceof NoopSpanContext)) {
            tracer.inject(spanContext, Format.Builtin.TEXT_MAP, new TextMap(){

                @Override
                public Iterator<Map.Entry<String, String>> iterator() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void put(String key, String value) {
                    keyValueConsumer.accept(key, value);
                }
            });
        }
    }

    public static SpanContext extractSpanContext(Tracer tracer, final Supplier<Iterator<Map.Entry<String, String>>> keyValueIteratorSupplier) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(keyValueIteratorSupplier);
        return tracer.extract(Format.Builtin.TEXT_MAP, new TextMap(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return (Iterator)keyValueIteratorSupplier.get();
            }

            @Override
            public void put(String key, String value) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static Tracer.SpanBuilder buildChildSpan(Tracer tracer, SpanContext spanContext, String operationName, String component) {
        return TracingHelper.buildSpan(tracer, spanContext, operationName, "child_of").ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), component);
    }

    public static Tracer.SpanBuilder buildServerChildSpan(Tracer tracer, SpanContext spanContext, String operationName, String component) {
        return TracingHelper.buildChildSpan(tracer, spanContext, operationName, component).withTag(Tags.SPAN_KIND.getKey(), "server");
    }

    public static Tracer.SpanBuilder buildFollowsFromSpan(Tracer tracer, SpanContext spanContext, String operationName) {
        return TracingHelper.buildSpan(tracer, spanContext, operationName, "follows_from");
    }

    public static Tracer.SpanBuilder buildSpan(Tracer tracer, SpanContext spanContext, String operationName, String referenceType) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(operationName);
        Objects.requireNonNull(referenceType);
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(operationName).addReference(referenceType, spanContext);
        TracingHelper.adoptSamplingPriorityFromContext(spanContext, spanBuilder);
        return spanBuilder;
    }

    public static void setTraceSamplingPriority(io.opentracing.Span span, int samplingPriority) {
        Objects.requireNonNull(span);
        Tags.SAMPLING_PRIORITY.set(span, samplingPriority);
        span.setBaggageItem(Tags.SAMPLING_PRIORITY.getKey(), Integer.toString(samplingPriority));
    }

    public static void adoptSamplingPriorityFromContext(SpanContext spanContext, Tracer.SpanBuilder spanBuilder) {
        Objects.requireNonNull(spanBuilder);
        if (spanContext != null) {
            for (Map.Entry<String, String> baggageItem : spanContext.baggageItems()) {
                if (!Tags.SAMPLING_PRIORITY.getKey().equals(baggageItem.getKey())) continue;
                spanBuilder.withTag(Tags.SAMPLING_PRIORITY.getKey(), baggageItem.getValue());
                break;
            }
        }
    }
}

