/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.connection;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpanContext;
import io.opentracing.propagation.Format;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonDelivery;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.Activity;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.auth.HonoUserAdapter;
import org.eclipse.hono.client.amqp.tracing.MessageAnnotationsExtractAdapter;
import org.eclipse.hono.client.amqp.tracing.MessageAnnotationsInjectAdapter;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.ResourceIdentifier;

public final class AmqpUtils {
    public static final Symbol AMQP_BAD_REQUEST = Symbol.valueOf("hono:bad-request");
    public static final Symbol AMQP_ERROR_INACTIVITY = Symbol.valueOf("hono:inactivity");
    public static final Symbol CAP_ANONYMOUS_RELAY = Symbol.valueOf("ANONYMOUS-RELAY");
    public static final String KEY_CLIENT_PRINCIPAL = "CLIENT_PRINCIPAL";
    public static final String SUBJECT_ANONYMOUS = "ANONYMOUS";
    public static final HonoUser PRINCIPAL_ANONYMOUS = new HonoUserAdapter(){
        private final Authorities authorities = new Authorities(){

            @Override
            public Map<String, Object> asMap() {
                return Collections.emptyMap();
            }

            @Override
            public boolean isAuthorized(ResourceIdentifier resourceId, Activity intent) {
                return false;
            }

            @Override
            public boolean isAuthorized(ResourceIdentifier resourceId, String operation) {
                return false;
            }
        };

        @Override
        public String getName() {
            return AmqpUtils.SUBJECT_ANONYMOUS;
        }

        @Override
        public Authorities getAuthorities() {
            return this.authorities;
        }
    };
    private static final String AMQP_ANNOTATION_NAME_TRACE_CONTEXT = "x-opt-trace-context";

    private AmqpUtils() {
    }

    private static HonoUser getClientPrincipal(Record record) {
        if (record != null) {
            HonoUser client = record.get(KEY_CLIENT_PRINCIPAL, HonoUser.class);
            return client != null ? client : PRINCIPAL_ANONYMOUS;
        }
        return PRINCIPAL_ANONYMOUS;
    }

    public static HonoUser getClientPrincipal(ProtonConnection con) {
        Record attachments = Objects.requireNonNull(con).attachments();
        return AmqpUtils.getClientPrincipal(attachments);
    }

    public static void setClientPrincipal(ProtonConnection con, HonoUser principal) {
        Objects.requireNonNull(principal);
        Record attachments = Objects.requireNonNull(con).attachments();
        attachments.set(KEY_CLIENT_PRINCIPAL, HonoUser.class, principal);
    }

    public static void injectSpanContext(Tracer tracer, SpanContext spanContext, Message message) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(message);
        if (spanContext != null && !(spanContext instanceof NoopSpanContext)) {
            tracer.inject(spanContext, Format.Builtin.TEXT_MAP, new MessageAnnotationsInjectAdapter(message, AMQP_ANNOTATION_NAME_TRACE_CONTEXT));
        }
    }

    public static SpanContext extractSpanContext(Tracer tracer, Message message) {
        Objects.requireNonNull(tracer);
        Objects.requireNonNull(message);
        return tracer.extract(Format.Builtin.TEXT_MAP, new MessageAnnotationsExtractAdapter(message, AMQP_ANNOTATION_NAME_TRACE_CONTEXT));
    }

    public static void rejected(ProtonDelivery delivery, ErrorCondition error) {
        Objects.requireNonNull(delivery);
        Rejected rejected = new Rejected();
        rejected.setError(error);
        delivery.disposition(rejected, true);
    }

    public static void addProperty(Message msg, String key, Object value) {
        Objects.requireNonNull(msg);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        ApplicationProperties props = Optional.ofNullable(msg.getApplicationProperties()).orElseGet(() -> {
            ApplicationProperties result = new ApplicationProperties(new HashMap<String, Object>());
            msg.setApplicationProperties(result);
            return result;
        });
        props.getValue().put(key, value);
    }

    public static <T> T getApplicationProperty(Message message, String name, Class<T> type) {
        return Optional.ofNullable(message).flatMap(msg -> Optional.ofNullable(msg.getApplicationProperties())).map(ApplicationProperties::getValue).map(props -> props.get(name)).filter(type::isInstance).map(type::cast).orElse(null);
    }

    public static void addCacheDirective(Message msg, CacheDirective cacheDirective) {
        AmqpUtils.addProperty(msg, "cache_control", cacheDirective.toString());
    }

    public static String getCacheDirective(Message msg) {
        return AmqpUtils.getApplicationProperty(msg, "cache_control", String.class);
    }

    public static void addTenantId(Message msg, String tenantId) {
        AmqpUtils.addProperty(msg, "tenant_id", tenantId);
    }

    public static String getTenantId(Message msg) {
        Objects.requireNonNull(msg);
        return AmqpUtils.getApplicationProperty(msg, "tenant_id", String.class);
    }

    public static void addDeviceId(Message msg, String deviceId) {
        AmqpUtils.addProperty(msg, "device_id", deviceId);
    }

    public static String getDeviceId(Message msg) {
        Objects.requireNonNull(msg);
        return AmqpUtils.getApplicationProperty(msg, "device_id", String.class);
    }

    public static String getGatewayId(Message msg) {
        Objects.requireNonNull(msg);
        return AmqpUtils.getApplicationProperty(msg, "gateway_id", String.class);
    }

    public static Integer getStatus(Message msg) {
        return AmqpUtils.getApplicationProperty(msg, "status", Integer.class);
    }

    public static void addStatus(Message msg, int status) {
        AmqpUtils.addProperty(msg, "status", status);
    }

    public static void addTimeUntilDisconnect(Message msg, int timeUntilDisconnect) {
        AmqpUtils.addProperty(msg, "ttd", timeUntilDisconnect);
    }

    public static Integer getTimeUntilDisconnect(Message msg) {
        return AmqpUtils.getApplicationProperty(msg, "ttd", Integer.class);
    }

    public static void setCreationTime(Message msg) {
        if (msg.getCreationTime() == 0L) {
            msg.setCreationTime(Instant.now().toEpochMilli());
        }
    }

    public static JsonObject getJsonPayload(Message msg) {
        return Optional.ofNullable(AmqpUtils.getPayload(msg)).filter(b -> b.length() > 0).map(Buffer::toJsonObject).orElse(null);
    }

    public static Buffer getPayload(Message msg) {
        Objects.requireNonNull(msg);
        return Optional.ofNullable(AmqpUtils.getPayloadByteArray(msg)).map(Buffer::buffer).orElse(null);
    }

    public static String getPayloadAsString(Message msg) {
        Objects.requireNonNull(msg);
        if (msg.getBody() instanceof AmqpValue && ((AmqpValue)msg.getBody()).getValue() instanceof String) {
            return (String)((AmqpValue)msg.getBody()).getValue();
        }
        return Optional.ofNullable(AmqpUtils.getPayload(msg)).map(Buffer::toString).orElse(null);
    }

    public static int getPayloadSize(Message msg) {
        Objects.requireNonNull(msg);
        return Optional.ofNullable(AmqpUtils.getPayloadByteArray(msg)).map(bytes -> ((byte[])bytes).length).orElse(0);
    }

    private static byte[] getPayloadByteArray(Message msg) {
        Objects.requireNonNull(msg);
        if (msg.getBody() == null) {
            return null;
        }
        if (msg.getBody() instanceof Data) {
            Data body = (Data)msg.getBody();
            return body.getValue().getArray();
        }
        if (msg.getBody() instanceof AmqpValue) {
            AmqpValue body = (AmqpValue)msg.getBody();
            if (body.getValue() instanceof byte[]) {
                return (byte[])body.getValue();
            }
            if (body.getValue() instanceof String) {
                return ((String)body.getValue()).getBytes(StandardCharsets.UTF_8);
            }
        }
        return null;
    }

    public static void setJsonPayload(Message message, JsonObject payload) {
        Objects.requireNonNull(message);
        AmqpUtils.setPayload(message, "application/json", Optional.ofNullable(payload).map(JsonObject::toBuffer).orElse(null));
    }

    public static void setJsonPayload(Message message, String payload) {
        Objects.requireNonNull(message);
        AmqpUtils.setPayload(message, "application/json", Optional.ofNullable(payload).map(Buffer::buffer).orElse(null));
    }

    public static void setPayload(Message message, String contentType, Buffer payload) {
        Objects.requireNonNull(message);
        AmqpUtils.setPayload(message, contentType, Optional.ofNullable(payload).map(Buffer::getBytes).orElse(null));
    }

    public static void setPayload(Message message, String contentType, byte[] payload) {
        Objects.requireNonNull(message);
        AmqpUtils.setPayload(message, contentType, payload, true);
    }

    public static void setPayload(Message message, String contentType, byte[] payload, boolean useDefaultContentTypeAsFallback) {
        Objects.requireNonNull(message);
        if (payload != null) {
            message.setBody(new Data(new Binary(payload)));
        }
        if (payload != null && contentType != null || "application/vnd.eclipse-hono-empty-notification".equals(contentType) || "application/vnd.eclipse-hono-device-provisioning-notification".equals(contentType)) {
            message.setContentType(contentType);
        } else if (payload != null && useDefaultContentTypeAsFallback) {
            message.setContentType("application/octet-stream");
        }
    }

    public static void annotate(Message msg, ResourceIdentifier resourceIdentifier) {
        AmqpUtils.addAnnotation(msg, "tenant_id", resourceIdentifier.getTenantId());
        if (resourceIdentifier.getResourceId() != null) {
            AmqpUtils.addAnnotation(msg, "device_id", resourceIdentifier.getResourceId());
        }
        AmqpUtils.addAnnotation(msg, "resource", resourceIdentifier.toString());
    }

    public static void addAnnotation(Message msg, String key, Object value) {
        MessageAnnotations annotations = msg.getMessageAnnotations();
        if (annotations == null) {
            annotations = new MessageAnnotations(new HashMap<Symbol, Object>());
            msg.setMessageAnnotations(annotations);
        }
        annotations.getValue().put(Symbol.getSymbol(key), value);
    }
}

