/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.graph.MetamodelNode;
import org.eclipse.hawk.graph.ModelElementNode;
import org.eclipse.hawk.graph.Slot;

public class TypeNode {
    private final IGraphNode node;
    private final String name;
    private Map<String, Slot> slots;

    public TypeNode(IGraphNode node) {
        this.node = node;
        this.name = (String)node.getProperty("_hawkid");
    }

    public IGraphNode getNode() {
        return this.node;
    }

    public MetamodelNode getMetamodel() {
        if (this.node.getGraph().currentMode() == IGraphDatabase.Mode.NO_TX_MODE) {
            throw new IllegalStateException("Cannot retrieve metamodel node from type in batch mode");
        }
        Iterator itEPackageEdges = this.node.getOutgoingWithType("epackage").iterator();
        IGraphEdge ePackageEdge = (IGraphEdge)itEPackageEdges.next();
        return new MetamodelNode(ePackageEdge.getEndNode());
    }

    public String getMetamodelURI() {
        return this.getMetamodel().getUri();
    }

    public String getTypeName() {
        return this.name;
    }

    public Slot getSlot(String name) {
        if (this.node.getProperty(name) != null) {
            return new Slot(this, name);
        }
        return null;
    }

    public Map<String, Slot> getSlots() {
        if (this.slots == null) {
            this.slots = new HashMap<String, Slot>();
            for (String propertyName : this.node.getPropertyKeys()) {
                Slot slot;
                if ("_hawkid".equals(propertyName) || !(slot = new Slot(this, propertyName)).isAttribute() && !slot.isReference() && !slot.isMixed() && !slot.isDerived()) continue;
                this.slots.put(propertyName, slot);
            }
        }
        return this.slots;
    }

    public List<TypeNode> getAllSupertypes() {
        ArrayList<TypeNode> superTypes = new ArrayList<TypeNode>();
        for (IGraphEdge e : this.node.getOutgoingWithType("_hawksuperclass")) {
            superTypes.add(new TypeNode(e.getEndNode()));
        }
        return superTypes;
    }

    public List<TypeNode> getAllSubtypes() {
        ArrayList<TypeNode> superTypes = new ArrayList<TypeNode>();
        for (IGraphEdge e : this.node.getIncomingWithType("_hawksuperclass")) {
            superTypes.add(new TypeNode(e.getStartNode()));
        }
        return superTypes;
    }

    public Iterable<ModelElementNode> getAll() {
        final Iterable iterableKind = this.node.getIncomingWithType("_hawkOfKind");
        return new Iterable<ModelElementNode>(){

            @Override
            public Iterator<ModelElementNode> iterator() {
                final Iterator itKind = iterableKind.iterator();
                return new Iterator<ModelElementNode>(){

                    @Override
                    public boolean hasNext() {
                        return itKind.hasNext();
                    }

                    @Override
                    public ModelElementNode next() {
                        return new ModelElementNode(((IGraphEdge)itKind.next()).getStartNode());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeNode other = (TypeNode)obj;
        return !(this.node == null ? other.node != null : !this.node.equals((Object)other.node));
    }
}

