/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.timeaware.queries.operations.reflective;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeReference;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.wrappers.GraphEdgeWrapper;
import org.eclipse.hawk.timeaware.queries.RiskyFunction;
import org.eclipse.hawk.timeaware.queries.TimeAwareEOLQueryEngine;

public class TimeAwareNodeHistoryOperationContributor
extends OperationContributor {
    private TimeAwareEOLQueryEngine model;

    public TimeAwareNodeHistoryOperationContributor(TimeAwareEOLQueryEngine q) {
        this.model = q;
    }

    public boolean contributesTo(Object target) {
        return target instanceof EOLQueryEngine.GraphNodeWrapper && ((EOLQueryEngine.GraphNodeWrapper)target).getNode() instanceof ITimeAwareGraphNode;
    }

    public List<IGraphNodeReference> getVersionsBetween(long fromInclusive, long toInclusive) throws EolRuntimeException {
        return this.getRelatedVersions(taNode -> taNode.getVersionsBetween(fromInclusive, toInclusive));
    }

    public List<IGraphNodeReference> getVersionsFrom(long fromInclusive) throws EolRuntimeException {
        return this.getRelatedVersions(taNode -> taNode.getVersionsFrom(fromInclusive));
    }

    public List<IGraphNodeReference> getVersionsUpTo(long toInclusive) throws EolRuntimeException {
        return this.getRelatedVersions(taNode -> taNode.getVersionsUpTo(toInclusive));
    }

    public IGraphNodeReference travelInTime(long time) {
        return this.model.wrap((IGraphNode)this.castTarget(this.getTarget()).travelInTime(time));
    }

    public List<GraphEdgeWrapper> getOutgoingEdgesWithTypeBetween(String type, long fromInclusive, long toInclusive) throws EolRuntimeException {
        ITimeAwareGraphNode taNode = this.castTarget(this.getTarget());
        return this.getEdgeList(() -> taNode.getOutgoingWithTypeBetween(type, fromInclusive, toInclusive));
    }

    public List<GraphEdgeWrapper> getIncomingEdgesWithTypeBetween(String type, long fromInclusive, long toInclusive) throws EolRuntimeException {
        ITimeAwareGraphNode taNode = this.castTarget(this.getTarget());
        return this.getEdgeList(() -> taNode.getIncomingWithTypeBetween(type, fromInclusive, toInclusive));
    }

    public List<GraphEdgeWrapper> getOutgoingEdgesWithTypeCreatedBetween(String type, long fromInclusive, long toInclusive) throws EolRuntimeException {
        ITimeAwareGraphNode taNode = this.castTarget(this.getTarget());
        return this.getEdgeList(() -> taNode.getOutgoingWithTypeCreatedBetween(type, fromInclusive, toInclusive));
    }

    public List<GraphEdgeWrapper> getIncomingEdgesWithTypeCreatedBetween(String type, long fromInclusive, long toInclusive) throws EolRuntimeException {
        ITimeAwareGraphNode taNode = this.castTarget(this.getTarget());
        return this.getEdgeList(() -> taNode.getIncomingWithTypeCreatedBetween(type, fromInclusive, toInclusive));
    }

    private List<GraphEdgeWrapper> getEdgeList(Callable<Iterable<IGraphEdge>> edgesCallable) throws EolRuntimeException {
        ArrayList<GraphEdgeWrapper> results = new ArrayList<GraphEdgeWrapper>();
        try {
            Iterable<IGraphEdge> edges = edgesCallable.call();
            for (IGraphEdge e : edges) {
                results.add(new GraphEdgeWrapper(e, (EOLQueryEngine)this.model));
            }
            return results;
        }
        catch (Exception e) {
            throw new EolRuntimeException(e.getMessage());
        }
    }

    private List<IGraphNodeReference> getRelatedVersions(RiskyFunction<ITimeAwareGraphNode, List<ITimeAwareGraphNode>> f) throws EolRuntimeException {
        ITimeAwareGraphNode taNode = this.castTarget(this.getTarget());
        ArrayList<IGraphNodeReference> results = new ArrayList<IGraphNodeReference>();
        try {
            for (ITimeAwareGraphNode version : f.call(taNode)) {
                results.add(this.model.wrap((IGraphNode)version));
            }
        }
        catch (Exception e) {
            throw new EolRuntimeException(e.getMessage());
        }
        return results;
    }

    private ITimeAwareGraphNode castTarget(Object target) {
        return (ITimeAwareGraphNode)((EOLQueryEngine.GraphNodeWrapper)target).getNode();
    }
}

