/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.mmselectors;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.ui2.mmselectors.IHawkMetaModelResourceSelector;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileSystemSelector
implements IHawkMetaModelResourceSelector {
    @Override
    public boolean isApplicableTo(IModelIndexer indexer) {
        return true;
    }

    @Override
    public void selectMetamodels(Shell parentShell, IModelIndexer indexer) throws Exception {
        FileDialog fd = new FileDialog(parentShell, 2);
        IPath workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        fd.setFilterPath(workspaceRoot.toFile().toString());
        fd.setFilterExtensions(IHawkMetaModelResourceSelector.getKnownMetamodelFilePatterns(indexer));
        fd.setText("Select metamodels");
        String result = fd.open();
        if (result != null) {
            String[] metaModels = fd.getFileNames();
            File[] metaModelFiles = new File[metaModels.length];
            int i = 0;
            while (i < metaModels.length) {
                metaModelFiles[i] = new File(fd.getFilterPath(), metaModels[i]);
                ++i;
            }
            indexer.registerMetamodels(metaModelFiles);
        }
    }
}

