/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.updater;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.model.IHawkClass;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkMetaModelResource;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.graph.TypeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeCache.class);
    private Map<IHawkClass, IGraphNode> hashedEClasses = new HashMap<IHawkClass, IGraphNode>();
    private Map<IGraphNode, Map<String, Slot>> hashedEClassSlots = new HashMap<IGraphNode, Map<String, Slot>>();
    private IModelIndexer hawk;

    public TypeCache(IModelIndexer hawk) {
        this.hawk = hawk;
    }

    public IGraphNode getEClassNode(IGraphDatabase graph, IHawkClassifier e) throws Exception {
        IHawkClass eClass = null;
        if (e instanceof IHawkClass) {
            eClass = (IHawkClass)e;
        } else {
            System.err.println("getEClassNode called on a non-class classifier:\n" + e);
        }
        IGraphNode classnode = this.hashedEClasses.get(eClass);
        if (classnode == null) {
            String packageNSURI = eClass.getPackageNSURI();
            IGraphNode ePackageNode = null;
            IGraphIterable iterMM = graph.getMetamodelIndex().get("id", (Object)packageNSURI);
            if (!iterMM.iterator().hasNext()) {
                LOGGER.info("Metamodel {} is not in the graph, trying to locate it", (Object)packageNSURI);
                for (IMetaModelResourceFactory mmp : this.hawk.getMetaModelParsers()) {
                    IHawkMetaModelResource mr = mmp.getMetamodel(packageNSURI);
                    if (mr == null) continue;
                    LOGGER.info("Found metamodel for {}, inserting", (Object)packageNSURI);
                    HashSet<IHawkMetaModelResource> setMR = new HashSet<IHawkMetaModelResource>(Arrays.asList(mr));
                    this.hawk.getMetaModelUpdater().insertMetamodels(setMR, this.hawk);
                }
            }
            try {
                ePackageNode = (IGraphNode)iterMM.getSingle();
            }
            catch (NoSuchElementException ex) {
                throw new Exception(String.format("Metamodel %s does not have a Node associated with it in the store, please make sure it has been inserted", packageNSURI));
            }
            catch (Exception e2) {
                LOGGER.error("Error while finding metamodel node", (Throwable)e2);
            }
            for (IGraphEdge r : ePackageNode.getEdges()) {
                Object id;
                IGraphNode otherNode = r.getStartNode();
                if (otherNode.equals((Object)ePackageNode) || !(id = otherNode.getProperty("_hawkid")).equals(eClass.getName())) continue;
                classnode = otherNode;
                break;
            }
            if (classnode == null) {
                throw new Exception(String.format("eClass: %s (%s) does not have a Node associated with it in the store, please make sure the metamodel %s has been inserted", eClass.getName(), eClass.getUri(), packageNSURI));
            }
            this.hashedEClasses.put(eClass, classnode);
            this.hashedEClassSlots.put(classnode, new TypeNode(classnode).getSlots());
        }
        return classnode;
    }

    public Map<String, Slot> getEClassNodeSlots(IGraphDatabase graph, IHawkClassifier e) throws Exception {
        return this.hashedEClassSlots.get(this.getEClassNode(graph, e));
    }
}

