/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.model.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.hawk.modelio.exml.model.parser.ExmlReference;

public class ExmlObject
extends ExmlReference {
    private String parentName;
    private String parentMClassName;
    private String parentUid;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final Map<String, List<ExmlReference>> compositions = new LinkedHashMap<String, List<ExmlReference>>();
    private final Map<String, List<ExmlReference>> links = new LinkedHashMap<String, List<ExmlReference>>();

    public ExmlObject(File f) {
        super(f);
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentMClassName() {
        return this.parentMClassName;
    }

    public void setParentMClassName(String parentMClassName) {
        this.parentMClassName = parentMClassName;
    }

    public String getParentUID() {
        return this.parentUid;
    }

    public void setParentUID(String parentUid) {
        this.parentUid = parentUid;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, String val) {
        if (val != null) {
            this.attributes.put(key, val);
        } else {
            this.attributes.remove(key);
        }
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void addToComposition(String key, ExmlReference ref) {
        List<ExmlReference> entries = this.compositions.get(key);
        if (entries == null) {
            entries = new ArrayList<ExmlReference>();
            this.compositions.put(key, entries);
        }
        entries.add(ref);
    }

    public Map<String, List<ExmlReference>> getCompositions() {
        return Collections.unmodifiableMap(this.compositions);
    }

    public void addToLink(String key, ExmlReference ref) {
        List<ExmlReference> entries = this.links.get(key);
        if (entries == null) {
            entries = new ArrayList<ExmlReference>();
            this.links.put(key, entries);
        }
        entries.add(ref);
    }

    public Map<String, List<ExmlReference>> getLinks() {
        return Collections.unmodifiableMap(this.links);
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        ExmlObject.buildString(sbuf, "\n  ", this);
        return sbuf.toString();
    }

    private static void buildString(StringBuffer sbuf, String indent, ExmlObject o) {
        sbuf.append("ExmlObject [");
        sbuf.append(indent);
        sbuf.append("name = ");
        sbuf.append(o.getName());
        sbuf.append(indent);
        sbuf.append("mClassName = ");
        sbuf.append(o.getMClassName());
        sbuf.append(indent);
        sbuf.append("uid = ");
        sbuf.append(o.getUID());
        sbuf.append(indent);
        sbuf.append("parentName = ");
        sbuf.append(o.parentName);
        sbuf.append(indent);
        sbuf.append("parentMClassName = ");
        sbuf.append(o.parentMClassName);
        sbuf.append(indent);
        sbuf.append("parentUid = ");
        sbuf.append(o.parentUid);
        sbuf.append(indent);
        sbuf.append("attributes = {");
        if (!o.attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : o.attributes.entrySet()) {
                sbuf.append(indent);
                sbuf.append("  ");
                sbuf.append(entry.getKey());
                sbuf.append(" = ");
                sbuf.append(entry.getValue());
            }
            sbuf.append(indent);
        }
        sbuf.append("}");
        sbuf.append(indent);
        sbuf.append("compositions = {");
        if (!o.compositions.isEmpty()) {
            for (Map.Entry<String, Object> entry : o.compositions.entrySet()) {
                sbuf.append(indent);
                sbuf.append("  ");
                sbuf.append(entry.getKey());
                sbuf.append(" = [");
                if (!((List)entry.getValue()).isEmpty()) {
                    for (ExmlReference ref : (List)entry.getValue()) {
                        sbuf.append(indent);
                        sbuf.append("    ");
                        if (ref instanceof ExmlObject) {
                            ExmlObject.buildString(sbuf, String.valueOf(indent) + "      ", (ExmlObject)ref);
                            continue;
                        }
                        sbuf.append(ref);
                    }
                }
                sbuf.append("]");
            }
            sbuf.append(indent);
        }
        sbuf.append("}");
        sbuf.append(indent);
        sbuf.append("links = {");
        if (!o.links.isEmpty()) {
            for (Map.Entry<String, Object> entry : o.links.entrySet()) {
                sbuf.append(indent);
                sbuf.append("  ");
                sbuf.append(entry.getKey());
                sbuf.append(" = [");
                if (!((List)entry.getValue()).isEmpty()) {
                    for (ExmlReference ref : (List)entry.getValue()) {
                        sbuf.append(indent);
                        sbuf.append("    ");
                        sbuf.append(ref);
                    }
                }
                sbuf.append("]");
            }
            sbuf.append(indent);
        }
        sbuf.append("}");
        sbuf.append("]");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.compositions == null ? 0 : this.compositions.hashCode());
        result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
        result = 31 * result + (this.parentMClassName == null ? 0 : this.parentMClassName.hashCode());
        result = 31 * result + (this.parentName == null ? 0 : this.parentName.hashCode());
        result = 31 * result + (this.parentUid == null ? 0 : this.parentUid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExmlObject other = (ExmlObject)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.compositions == null ? other.compositions != null : !this.compositions.equals(other.compositions)) {
            return false;
        }
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.parentMClassName == null ? other.parentMClassName != null : !this.parentMClassName.equals(other.parentMClassName)) {
            return false;
        }
        if (this.parentName == null ? other.parentName != null : !this.parentName.equals(other.parentName)) {
            return false;
        }
        return !(this.parentUid == null ? other.parentUid != null : !this.parentUid.equals(other.parentUid));
    }
}

