/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.api.dt.ui;

import org.eclipse.hawk.service.api.dt.prefs.CredentialsStore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ServerConfigurationDialog
extends Dialog {
    private static final int RESET_ID = 22;
    private Text locationField;
    private Text usernameField;
    private Text passwordField;
    private final String title;
    private String username = "admin";
    private String password = "password";
    private String location;

    public ServerConfigurationDialog(Shell parentShell, String title, String location) {
        super(parentShell);
        this.title = title;
        this.location = location;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.numColumns = 2;
        Label locationLabel = new Label(comp, 131072);
        locationLabel.setText("Base URI: ");
        this.locationField = new Text(comp, 2052);
        GridData data = new GridData(768);
        this.locationField.setLayoutData((Object)data);
        if (this.location != null) {
            this.locationField.setText(this.location);
        }
        Label usernameLabel = new Label(comp, 131072);
        usernameLabel.setText("Username: ");
        this.usernameField = new Text(comp, 2052);
        data = new GridData(768);
        this.usernameField.setLayoutData((Object)data);
        if (this.username != null) {
            this.usernameField.setText(this.username);
        }
        Label passwordLabel = new Label(comp, 131072);
        passwordLabel.setText("Password: ");
        this.passwordField = new Text(comp, 0x400804);
        data = new GridData(768);
        this.passwordField.setLayoutData((Object)data);
        if (this.password != null) {
            this.passwordField.setText(this.password);
        }
        return comp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 22, "Reset All", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 22) {
            this.usernameField.setText("");
            this.passwordField.setText("");
            this.locationField.setText(this.location);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.username = this.usernameField.getText();
        this.password = this.passwordField.getText();
        this.location = this.locationField.getText();
        super.okPressed();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLocation() {
        return this.location;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public CredentialsStore.Credentials getCredentials() {
        return new CredentialsStore.Credentials(this.username, this.password);
    }

    public void setCredentials(CredentialsStore.Credentials creds) {
        this.setUsername(creds.getUsername());
        this.setPassword(creds.getPassword());
    }
}

