/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.api.dt.prefs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.hawk.service.api.dt.prefs.Server;
import org.eclipse.jface.preference.IPreferenceStore;

public class ServerStore {
    private static final String HAWK_SERVERS_PREFERENCE = "hawkServerURLs";
    private static final String URL_SEPARATOR = ",";
    private final IPreferenceStore prefStore;

    public ServerStore(IPreferenceStore prefStore) {
        this.prefStore = prefStore;
    }

    public List<Server> readAllServers() {
        String sValue = this.prefStore.getString(HAWK_SERVERS_PREFERENCE);
        ArrayList<Server> servers = new ArrayList<Server>();
        if (!"".equals(sValue)) {
            String[] urls;
            String[] stringArray = urls = sValue.split(URL_SEPARATOR);
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                servers.add(new Server(url));
                ++n2;
            }
        }
        return servers;
    }

    public void saveAllServers(List<Server> servers) {
        StringBuffer sbuf = new StringBuffer();
        boolean first = true;
        for (Server server : servers) {
            if (first) {
                first = false;
            } else {
                sbuf.append(URL_SEPARATOR);
            }
            sbuf.append(server.getBaseURL());
        }
        this.prefStore.putValue(HAWK_SERVERS_PREFERENCE, sbuf.toString());
    }
}

