/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.codemining;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.internal.texteditor.codemining.CodeMiningProviderDescriptor;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodeMiningProviderRegistry {
    public static final String CODEMINING_PROVIDERS_EXTENSION_POINT = "codeMiningProviders";
    private CodeMiningProviderDescriptor[] fDescriptors;
    private boolean fLoaded = false;

    private CodeMiningProviderDescriptor[] getDescriptors() {
        this.ensureExtensionsLoaded();
        return this.fDescriptors;
    }

    public synchronized void reloadExtensions() {
        IConfigurationElement[] elements;
        ArrayList<CodeMiningProviderDescriptor> descriptors = new ArrayList<CodeMiningProviderDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.workbench.texteditor", CODEMINING_PROVIDERS_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                CodeMiningProviderDescriptor descriptor = new CodeMiningProviderDescriptor(element);
                descriptors.add(descriptor);
            }
            catch (CoreException e) {
                TextEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, element.getNamespaceIdentifier(), e.getMessage()));
            }
            ++n2;
        }
        this.fDescriptors = descriptors.toArray(new CodeMiningProviderDescriptor[descriptors.size()]);
        this.fLoaded = true;
    }

    private void ensureExtensionsLoaded() {
        if (!this.fLoaded) {
            this.reloadExtensions();
        }
    }

    public ICodeMiningProvider[] getProviders(ISourceViewer viewer, ITextEditor editor) {
        ArrayList<ICodeMiningProvider> providers = new ArrayList<ICodeMiningProvider>();
        CodeMiningProviderDescriptor[] codeMiningProviderDescriptorArray = this.getDescriptors();
        int n = codeMiningProviderDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICodeMiningProvider provider;
            CodeMiningProviderDescriptor descriptor = codeMiningProviderDescriptorArray[n2];
            if (descriptor.matches(viewer, editor) && (provider = descriptor.createCodeMiningProvider(editor)) != null) {
                providers.add(provider);
            }
            ++n2;
        }
        return !providers.isEmpty() ? providers.toArray(new ICodeMiningProvider[providers.size()]) : null;
    }
}

