/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.hawk.orientdb.OrientNode;

public class OrientIndexStore {
    private static final String NODEIDX_PROP = "nodeIndexes";
    private static final String NODEFIELDIDX_PREFIX = "nidx_";
    private static final String EDGEIDX_PROP = "edgeIndexes";
    private static final String EDGEFIELDIDX_PREFIX = "eidx_";
    private final OrientNode vIndexStore;

    public OrientIndexStore(OrientNode n) {
        this.vIndexStore = n;
        if (this.vIndexStore.getProperty(NODEIDX_PROP) == null) {
            this.vIndexStore.setProperty(NODEIDX_PROP, new String[0]);
        }
        if (this.vIndexStore.getProperty(EDGEIDX_PROP) == null) {
            this.vIndexStore.setProperty(EDGEIDX_PROP, new String[0]);
        }
    }

    public void addNodeIndex(String indexName) {
        String property = NODEIDX_PROP;
        this.addIndex(indexName, NODEIDX_PROP);
    }

    public void addEdgeIndex(String indexName) {
        String property = EDGEIDX_PROP;
        this.addIndex(indexName, EDGEIDX_PROP);
    }

    public void addNodeFieldIndex(String indexName, String field) {
        this.addNodeIndex(indexName);
        this.addFieldIndex(NODEFIELDIDX_PREFIX, indexName, field);
    }

    public void addEdgeFieldIndex(String indexName, String field) {
        this.addEdgeIndex(indexName);
        this.addFieldIndex(EDGEFIELDIDX_PREFIX, indexName, field);
    }

    public Set<String> getNodeFieldIndexNames(String indexName) {
        return this.getFieldIndexNames(NODEFIELDIDX_PREFIX, indexName);
    }

    public Set<String> getEdgeFieldIndexNames(String indexName) {
        return this.getFieldIndexNames(EDGEFIELDIDX_PREFIX, indexName);
    }

    public Set<String> getNodeIndexNames() {
        return this.getIndexNames(NODEIDX_PROP);
    }

    public Set<String> getEdgeIndexNames() {
        return this.getIndexNames(EDGEIDX_PROP);
    }

    public void removeNodeIndex(String indexName) {
        String propName = NODEFIELDIDX_PREFIX + indexName;
        this.vIndexStore.removeProperty(propName);
        Set<String> nodeIndexNames = this.getNodeIndexNames();
        nodeIndexNames.remove(indexName);
        this.vIndexStore.setProperty(NODEIDX_PROP, nodeIndexNames.toArray(new String[nodeIndexNames.size()]));
        this.vIndexStore.save();
    }

    private void addIndex(String indexName, String property) {
        Set<String> setNames = this.getIndexNames(property);
        if (setNames.add(indexName)) {
            String[] extendedNames = setNames.toArray(new String[setNames.size()]);
            this.vIndexStore.setProperty(property, extendedNames);
            this.vIndexStore.save();
        }
    }

    private void addFieldIndex(String prefix, String indexName, String field) {
        String propName = String.valueOf(prefix) + indexName;
        Set<String> setNames = this.getNodeFieldIndexNames(indexName);
        if (setNames.add(field)) {
            String[] extNames = setNames.toArray(new String[setNames.size()]);
            this.vIndexStore.setProperty(propName, extNames);
            this.vIndexStore.save();
        }
    }

    private Set<String> getFieldIndexNames(String prefix, String indexName) {
        String propName = String.valueOf(prefix) + indexName;
        HashSet<String> setNames = new HashSet<String>();
        Object oNames = this.vIndexStore.getProperty(propName);
        if (oNames instanceof Collection) {
            setNames.addAll((Collection)oNames);
        } else if (oNames != null) {
            setNames.addAll(Arrays.asList((String[])oNames));
        }
        return setNames;
    }

    private Set<String> getIndexNames(String property) {
        Object oNames = this.vIndexStore.getProperty(property);
        if (oNames instanceof Collection) {
            return new HashSet<String>((Collection)oNames);
        }
        if (oNames instanceof String[]) {
            return new HashSet<String>(Arrays.asList((String[])oNames));
        }
        return new HashSet<String>();
    }
}

