/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.IMetaModelResourceFactory;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkMetaModelResource;
import org.eclipse.hawk.core.model.IHawkObject;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioClass;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioDataType;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioMetaModelResourceFactory;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioPackage;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MAttribute;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MClass;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MMetamodel;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MPackage;
import org.eclipse.hawk.modelio.exml.metamodel.parser.MMetamodelDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelioMetaModelResource
implements IHawkMetaModelResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelioMetaModelResource.class);
    public static final String META_PKG_NAME = "ModelioMetaPackage";
    public static final String META_TYPE_NAME = "ModelioType";
    public static final String META_PKG_VERSION = "00.00.00";
    protected static final String STRING_TYPE = "java.lang.String";
    private final ModelioMetaModelResourceFactory factory;
    private final ModelioPackage metaPackage;
    private MMetamodel metamodel;
    private Set<IHawkObject> contents;
    private Map<String, ModelioClass> classesById;

    public ModelioMetaModelResource(MMetamodelDescriptor metamodelDescriptor, ModelioMetaModelResourceFactory factory) {
        this.metamodel = new MMetamodel(metamodelDescriptor);
        this.factory = factory;
        this.metaPackage = new ModelioPackage(this, this.createMetaPackage());
        this.classesById = new HashMap<String, ModelioClass>();
    }

    public MMetamodel getMetamodel() {
        return this.metamodel;
    }

    private MPackage createMetaPackage() {
        MPackage mpkg = new MPackage(META_PKG_NAME, META_PKG_NAME, META_PKG_VERSION, "");
        MClass mt = new MClass(META_TYPE_NAME, META_TYPE_NAME);
        mt.getMAttributes().add(this.createStringAttribute(mpkg, mt.getName(), "name"));
        mpkg.getMClass().add(mt);
        return mpkg;
    }

    public void unload() {
        this.metamodel = null;
        this.contents = null;
        this.classesById = null;
    }

    public Set<IHawkObject> getAllContents() {
        if (this.contents == null) {
            this.contents = new HashSet<IHawkObject>();
            this.addMPackageToContents(this.metaPackage);
            for (MPackage pkg : this.metamodel.getMPackages()) {
                this.addMPackageToContents(new ModelioPackage(this, pkg));
            }
        }
        return this.contents;
    }

    public ModelioPackage getModelioPackage(String name) {
        for (IHawkObject o : this.getAllContents()) {
            ModelioPackage pkg;
            if (!(o instanceof ModelioPackage) || !name.equals((pkg = (ModelioPackage)o).getName())) continue;
            return pkg;
        }
        return null;
    }

    private void addMPackageToContents(ModelioPackage pkg) {
        this.contents.add(pkg);
        for (IHawkClassifier cl : pkg.getClasses()) {
            this.contents.add((IHawkObject)cl);
            if (this.classesById.put(((ModelioClass)cl).getId(), (ModelioClass)cl) == null) continue;
            LOGGER.error("Class name '{}' is not unique", (Object)cl.getName());
        }
        for (ModelioPackage subpkg : pkg.getPackages()) {
            this.addMPackageToContents(subpkg);
        }
    }

    public IMetaModelResourceFactory getMetaModelResourceFactory() {
        return this.factory;
    }

    public void save(OutputStream output, Map<Object, Object> options) throws IOException {
    }

    public ModelioClass getMetaType() {
        return this.metaPackage.getClassifier(META_TYPE_NAME);
    }

    public ModelioPackage getMetaPackage() {
        return this.metaPackage;
    }

    public ModelioClass getModelioClassById(String classId) {
        this.getAllContents();
        ModelioClass mc = this.classesById.get(classId);
        if (mc != null) {
            return mc;
        }
        return null;
    }

    private MAttribute createStringAttribute(MPackage rawPackage, String className, String attrName) {
        boolean isMany = false;
        boolean isUnique = false;
        boolean isOrdered = false;
        return new MAttribute(String.valueOf(className) + "_" + attrName, attrName, this.metamodel.getDataTypeByName(STRING_TYPE), false, false, false);
    }

    public ModelioDataType getStringDataType() {
        return new ModelioDataType(this.getMetaPackage(), this.metamodel.getDataTypeByName(STRING_TYPE));
    }
}

