/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb.indexes;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.hawk.orientdb.indexes.AbstractOrientIndex;
import org.eclipse.hawk.orientdb.indexes.FragmentFilteredIndexCursor;
import org.eclipse.hawk.orientdb.indexes.OIndexCursorFactory;

final class SingleKeyOIndexCursorFactory
implements OIndexCursorFactory {
    private final Object valueExpr;
    private final AbstractOrientIndex idx;
    private final String fieldName;
    private final boolean isRemote;
    private final Class<? extends Object> valueClass;

    SingleKeyOIndexCursorFactory(Object valueExpr, AbstractOrientIndex idx, String fieldName) {
        this.valueExpr = valueExpr;
        this.idx = idx;
        this.fieldName = fieldName;
        Class tempValueClass = valueExpr.getClass();
        if ("*".equals(valueExpr)) {
            for (Class klass : Arrays.asList(Integer.class, Double.class, String.class)) {
                if (idx.getIndex(klass) == null) continue;
                tempValueClass = klass;
            }
        }
        this.valueClass = tempValueClass;
        this.isRemote = idx.getDatabase().getGraph().getURL().startsWith("remote:");
    }

    @Override
    public Iterator<OIdentifiable> query() {
        OIndex<?> index = this.idx.getIndex(this.valueClass);
        if (index == null) {
            return Collections.emptyListIterator();
        }
        Set<OCompositeKey> keys = Collections.singleton(new OCompositeKey(new Object[]{this.fieldName, this.valueExpr}));
        if (!(this.valueExpr instanceof String)) {
            return this.iterateEntries(index, keys);
        }
        String sValueExpr = this.valueExpr.toString();
        int starPosition = sValueExpr.indexOf(42);
        if (starPosition < 0) {
            return this.iterateEntries(index, keys);
        }
        if (starPosition == 0) {
            if (sValueExpr.length() == 1) {
                if (this.isRemote) {
                    return index.cursor();
                }
                Object minValue = AbstractOrientIndex.getMinValue(this.valueClass);
                Object maxValue = AbstractOrientIndex.getMaxValue(this.valueClass);
                return AbstractOrientIndex.iterateEntriesBetween(this.fieldName, minValue, maxValue, true, true, index, this.idx.getDatabase().getGraph());
            }
            String[] fragments = sValueExpr.split("[*]");
            OIndexCursor cursor = index.cursor();
            return new FragmentFilteredIndexCursor(fragments, cursor);
        }
        if (starPosition == sValueExpr.length() - 1) {
            String prefix = sValueExpr.substring(0, starPosition);
            return this.prefixCursor(index, prefix);
        }
        String[] fragments = sValueExpr.split("[*]");
        OIndexCursor cursor = this.prefixCursor(index, sValueExpr.substring(0, starPosition));
        return new FragmentFilteredIndexCursor(fragments, cursor);
    }

    protected Iterator<OIdentifiable> iterateEntries(OIndex<?> index, Set<OCompositeKey> keys) {
        if (this.isRemote) {
            StringBuilder params = new StringBuilder(128);
            if (!keys.isEmpty()) {
                params.append("?");
                int i = 1;
                while (i < keys.size()) {
                    params.append(", ?");
                    ++i;
                }
            }
            String text = String.format("select from index:%s where key in [%s]", index.getName(), params.toString());
            OCommandSQL cmd = new OCommandSQL(text);
            Collection entries = (Collection)this.idx.getDatabase().getGraph().command((OCommandRequest)cmd).execute(keys.toArray());
            final Iterator itEntries = entries.iterator();
            return new Iterator<OIdentifiable>(){

                @Override
                public boolean hasNext() {
                    return itEntries.hasNext();
                }

                @Override
                public OIdentifiable next() {
                    return (OIdentifiable)((ODocument)itEntries.next()).field("rid");
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("iterateEntries iterator");
                }
            };
        }
        return index.iterateEntries(keys, false);
    }

    private OIndexCursor prefixCursor(OIndex<?> index, String prefix) {
        char lastChar = prefix.charAt(prefix.length() - 1);
        String rangeStart = prefix;
        String rangeEnd = String.valueOf(prefix.substring(0, rangeStart.length() - 1)) + Character.toString((char)(lastChar + '\u0001'));
        return AbstractOrientIndex.iterateEntriesBetween(this.fieldName, rangeStart, rangeEnd, true, true, index, this.idx.getDatabase().getGraph());
    }
}

