/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.v3.admin.MonitoringReporter;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Dom;

@Service(name="list")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
public class ListCommand
extends V2DottedNameSupport
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    @Inject
    private MonitoringReporter mr;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    Target targetService;
    @Inject
    ServiceLocator habitat;
    @Param(name="MoniTor", optional=true, defaultValue="false", shortName="m", alias="Mon")
    Boolean monitor;
    @Param(primary=true)
    String pattern = "";
    @Inject
    @Optional
    private MonitoringRuntimeDataRegistry mrdr;
    private Map<Dom, String> matchingNodes;
    private V2DottedNameSupport.TreeNode[] parentNodes;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        if (this.monitor.booleanValue()) {
            return this.preAuthorizationForMonitoring(context);
        }
        return this.preAuthorizationForNonMonitoring(context);
    }

    private boolean preAuthorizationForMonitoring(AdminCommandContext context) {
        this.mr.prepareList(context, this.pattern);
        return true;
    }

    private boolean preAuthorizationForNonMonitoring(AdminCommandContext context) {
        this.parentNodes = this.getAliasedParent(this.domain, this.pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : this.parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        this.pattern = this.parentNodes[0].relativeName;
        this.matchingNodes = this.getMatchingNodes(dottedNames, this.pattern);
        if (this.matchingNodes.isEmpty() && this.pattern.lastIndexOf(46) != -1) {
            this.matchingNodes = this.getMatchingNodes(dottedNames, this.pattern.substring(0, this.pattern.lastIndexOf(".")));
        }
        return true;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        if (this.monitor.booleanValue()) {
            return this.getAccessChecksForMonitoring();
        }
        return this.getAccessChecksForNonMonitoring();
    }

    private Collection<? extends AccessRequired.AccessCheck> getAccessChecksForMonitoring() {
        return this.mr.getAccessChecksForList();
    }

    private Collection<? extends AccessRequired.AccessCheck> getAccessChecksForNonMonitoring() {
        ArrayList accessChecks = new ArrayList();
        for (Map.Entry<Dom, String> entry : this.matchingNodes.entrySet()) {
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromDom(entry.getKey()), "read"));
        }
        return accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PropsFileActionReporter reporter = (PropsFileActionReporter)report;
            reporter.useMainChildrenAttribute(true);
        }
        catch (ClassCastException reporter) {
            // empty catch block
        }
        if (this.monitor.booleanValue()) {
            this.listMonitorElements(context);
            return;
        }
        List<Map.Entry> matchingNodesSorted = this.sortNodesByDottedName(this.matchingNodes);
        for (Map.Entry node : matchingNodesSorted) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setChildrenType("DottedName");
            if (this.parentNodes[0].name.isEmpty()) {
                part.setMessage((String)node.getValue());
                continue;
            }
            part.setMessage(this.parentNodes[0].name + "." + (String)node.getValue());
        }
    }

    private void listMonitorElements(AdminCommandContext ctxt) {
        this.mr.execute();
    }

    public void callInstance(ActionReport report, AdminCommandContext context, String targetName) {
        try {
            ParameterMap paramMap = new ParameterMap();
            paramMap.set("MoniTor", "true");
            paramMap.set("DEFAULT", this.pattern);
            List targetList = this.targetService.getInstances(targetName);
            ClusterOperationUtil.replicateCommand((String)"list", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (FailurePolicy)FailurePolicy.Ignore, (List)targetList, (AdminCommandContext)context, (ParameterMap)paramMap, (ServiceLocator)this.habitat);
        }
        catch (Exception ex) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("Failure while trying get details from instance " + targetName);
        }
    }
}

