/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity.parser;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.parser.ConfigurationPopulator;
import com.sun.enterprise.config.serverbeans.ConfigLoader;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class ConfigurationParser<C extends ConfigLoader> {
    private static final Logger LOG = ConfigApiLoggerInfo.getLogger();
    private static boolean replaceSystemProperties = false;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private ConfigModularityUtils configModularityUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ConfigBeanProxy> void parseAndSetConfigBean(List<ConfigBeanDefaultValue> values) {
        ConfigParser configParser = new ConfigParser(this.serviceLocator);
        DomDocument<GlassFishConfigBean> doc = new DomDocument<GlassFishConfigBean>(this.serviceLocator){

            public Dom make(ServiceLocator serviceLocator, XMLStreamReader xmlStreamReader, GlassFishConfigBean dom, ConfigModel configModel) {
                return new GlassFishConfigBean(serviceLocator, this, dom, configModel, xmlStreamReader);
            }
        };
        for (final ConfigBeanDefaultValue configBeanDefaultValue : values) {
            ConfigBeanProxy parent = this.configModularityUtils.getOwningObject(configBeanDefaultValue.getLocation());
            if (parent == null) continue;
            ConfigurationPopulator populator = null;
            if (replaceSystemProperties) {
                try {
                    populator = new ConfigurationPopulator(this.configModularityUtils.replacePropertiesWithCurrentValue(configBeanDefaultValue.getXmlConfiguration(), configBeanDefaultValue), (DomDocument)doc, parent);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "NCLS-CFGAPI-00123", e);
                }
            } else {
                populator = new ConfigurationPopulator(configBeanDefaultValue.getXmlConfiguration(), (DomDocument)doc, parent);
            }
            populator.run(configParser);
            ConfigModularityUtils configModularityUtils = this.configModularityUtils;
            synchronized (configModularityUtils) {
                boolean oldValue = this.configModularityUtils.isIgnorePersisting();
                try {
                    Class configBeanClass = this.configModularityUtils.getClassForFullName(configBeanDefaultValue.getConfigBeanClassName());
                    final ConfigBeanProxy pr = doc.getRoot().createProxy(configBeanClass);
                    this.configModularityUtils.setIgnorePersisting(true);
                    ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ConfigBeanProxy>(){

                        public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                            ConfigurationParser.this.configModularityUtils.setConfigBean(pr, configBeanDefaultValue, param);
                            return param;
                        }
                    }, (ConfigBeanProxy)parent);
                }
                catch (TransactionFailure e) {
                    LOG.log(Level.SEVERE, "NCLS-CFGAPI-00123", e);
                }
                finally {
                    this.configModularityUtils.setIgnorePersisting(oldValue);
                }
            }
        }
    }
}

