/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.jmq.jmsclient.ContainerType;
import com.sun.messaging.jmq.jmsclient.XAConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XAJMSContextImpl;
import com.sun.messaging.jmq.jmsclient.XAQueueConnectionImpl;
import com.sun.messaging.jmq.jmsclient.XATopicConnectionImpl;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAJMSContext;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class XAConnectionFactory
extends ConnectionFactory
implements javax.jms.XAConnectionFactory {
    private static final long serialVersionUID = 5439435099986481737L;
    private static ContainerType containerType;

    @Override
    public XAConnection createXAConnection() throws JMSException {
        return this.createXAConnection(this.getProperty("imqDefaultUsername"), this.getProperty("imqDefaultPassword"));
    }

    @Override
    public XAConnection createXAConnection(String username, String password) throws JMSException {
        return new XAConnectionImpl(this.getCurrentConfiguration(), username, password, this.getConnectionType());
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createXAQueueConnection(this.getProperty("imqDefaultUsername"), this.getProperty("imqDefaultPassword"));
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return new XAQueueConnectionImpl(this.getCurrentConfiguration(), username, password, this.getConnectionType());
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createXATopicConnection(this.getProperty("imqDefaultUsername"), this.getProperty("imqDefaultPassword"));
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return new XATopicConnectionImpl(this.getCurrentConfiguration(), username, password, this.getConnectionType());
    }

    @Override
    public XAJMSContext createXAContext() {
        return new XAJMSContextImpl(this, XAConnectionFactory.getContainerType());
    }

    @Override
    public XAJMSContext createXAContext(String userName, String password) {
        return new XAJMSContextImpl(this, XAConnectionFactory.getContainerType(), userName, password);
    }

    protected static ContainerType getContainerType() {
        if (containerType == null) {
            String lookupName = "java:comp/InAppClientContainer";
            try {
                InitialContext ic = new InitialContext();
                Boolean inAppClientContainer = (Boolean)ic.lookup(lookupName);
                containerType = inAppClientContainer.booleanValue() ? ContainerType.JavaEE_ACC : ContainerType.JavaEE_Web_or_EJB;
            }
            catch (NamingException e) {
                containerType = ContainerType.JavaSE;
            }
        }
        return containerType;
    }
}

