/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats;

import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import com.sun.enterprise.util.i18n.StringManager;
import org.glassfish.j2ee.statistics.TimeStatistic;

public class TimeStatisticImpl
extends StatisticImpl
implements TimeStatistic {
    private final long count;
    private final long maxTime;
    private final long minTime;
    private final long totTime;
    private static final StringManager localStrMgr = StringManager.getManager(TimeStatisticImpl.class);

    @Override
    public final String toString() {
        return super.toString() + NEWLINE + "Count: " + this.getCount() + NEWLINE + "MinTime: " + this.getMinTime() + NEWLINE + "MaxTime: " + this.getMaxTime() + NEWLINE + "TotalTime: " + this.getTotalTime();
    }

    public TimeStatisticImpl(String name) {
        this(name, StatisticImpl.DEFAULT_UNIT);
    }

    public TimeStatisticImpl(String name, String unit) {
        this(StatisticImpl.DEFAULT_VALUE, StatisticImpl.DEFAULT_VALUE, StatisticImpl.DEFAULT_VALUE, StatisticImpl.DEFAULT_VALUE, name, unit, Util.getDescriptionFromName(name), Util.getInitTime()[0], Util.getInitTime()[1]);
    }

    public TimeStatisticImpl(String name, String unit, String desc) {
        this(StatisticImpl.DEFAULT_VALUE, StatisticImpl.DEFAULT_VALUE, StatisticImpl.DEFAULT_VALUE, StatisticImpl.DEFAULT_VALUE, name, unit, desc, Util.getInitTime()[0], Util.getInitTime()[1]);
    }

    public TimeStatisticImpl(long counter, long maximumTime, long minimumTime, long totalTime, String name, String unit, String desc, long startTime, long sampleTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.count = counter;
        this.maxTime = maximumTime;
        this.minTime = minimumTime;
        this.totTime = totalTime;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getMaxTime() {
        return this.maxTime;
    }

    @Override
    public long getMinTime() {
        return this.minTime;
    }

    @Override
    public long getTotalTime() {
        return this.totTime;
    }

    private static class Util {
        private Util() {
        }

        private static String getDescriptionFromName(String name) {
            return localStrMgr.getString("describes_string") + name;
        }

        private static long[] getInitTime() {
            long time = System.currentTimeMillis();
            return new long[]{time, time};
        }
    }
}

