/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.blc;

import com.sun.messaging.jmq.admin.jmsspi.JMSAdminFactoryImpl;
import com.sun.messaging.jmq.jmsspi.JMSAdmin;
import com.sun.messaging.jmq.jmsspi.PropertiesHolder;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSSecurityException;

public class LocalBrokerRunner {
    private JMSAdmin jmsadmin = null;
    private JMSAdmin tjmsadmin = null;
    private String adminUsername;
    private String adminPassFile;
    String[] brokerArgs;
    String brokerBinDir;
    String brokerVarDir;
    String brokerInstanceName;
    String brokerLogFilename;
    int brokerStartTimeout;
    private boolean startedByAS = false;
    private boolean startingRMIRegistry = false;
    private String brokerURL;
    private static final transient String _className = "com.sun.messaging.jms.ra.LocalBrokerRunner";
    protected static final transient String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    protected static final transient Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_LB";
    protected static final transient String _lgrMID_EET = "MQJMSRA_LB1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_LB1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_LB2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_LB3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_LB4001: ";

    public LocalBrokerRunner(String brokerURL, String brokerInstanceName, String brokerBindAddress, int brokerPort, String brokerHomeDir, String brokerLibDir, String brokerVarDir, String brokerJavaDir, String brokerExtraArgs, boolean useJNDIRMIServiceURL, int rmiRegistryPort, boolean startRMIRegistry, boolean useSSLJMXConnector, int brokerStartTimeout, String adminUsername, String adminPassFile, PropertiesHolder brokerPropertiesHolder) throws Exception {
        if (_loggerL.isLoggable(Level.FINER)) {
            Object[] params = new Object[]{brokerURL, brokerInstanceName, brokerBindAddress, Integer.toString(brokerPort), brokerHomeDir, brokerLibDir, brokerVarDir, brokerJavaDir, brokerExtraArgs, useJNDIRMIServiceURL, rmiRegistryPort, startRMIRegistry, useSSLJMXConnector, adminUsername, adminPassFile, brokerPropertiesHolder.getProperties()};
            _loggerL.entering(_className, "constructor()", params);
        }
        this.brokerURL = brokerURL;
        this.adminUsername = adminUsername;
        this.brokerStartTimeout = brokerStartTimeout;
        String adminPassword = brokerPropertiesHolder.getProperties().getProperty("imq.imqcmd.password");
        this.jmsadmin = new JMSAdminFactoryImpl().getJMSAdmin(brokerURL, brokerPropertiesHolder, adminUsername, adminPassword);
        this.tjmsadmin = new JMSAdminFactoryImpl().getJMSAdmin(brokerURL, brokerPropertiesHolder, "admin", "admin");
        LocalBrokerRunner.checkVersion(this.jmsadmin);
        Vector<String> v = new Vector<String>();
        if (brokerJavaDir != null) {
            v.add("-javahome");
            v.add(brokerJavaDir);
        }
        if (brokerExtraArgs != null && !"".equals(brokerExtraArgs)) {
            StringTokenizer st = new StringTokenizer(brokerExtraArgs, " ");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                v.add(t);
            }
        }
        this.brokerInstanceName = brokerInstanceName;
        this.brokerBinDir = brokerHomeDir + File.separator + "bin";
        this.brokerVarDir = brokerVarDir;
        this.brokerLogFilename = brokerVarDir + File.separator + "instances" + File.separator + brokerInstanceName + File.separator + "log" + File.separator + "log.txt";
        this.startedByAS = false;
        this.startingRMIRegistry = false;
        if (brokerVarDir != null) {
            v.add("-varhome");
            v.add(brokerVarDir);
        }
        if (useJNDIRMIServiceURL) {
            if (startRMIRegistry) {
                v.add("-startRmiRegistry");
                this.startingRMIRegistry = true;
            } else {
                v.add("-useRmiRegistry");
                this.startingRMIRegistry = false;
            }
            v.add("-rmiRegistryPort");
            v.add(Integer.toString(rmiRegistryPort));
        }
        if (adminUsername != null && !"".equals(adminUsername)) {
            if (adminPassFile != null && !"".equals(adminPassFile)) {
                v.add("-Dimq.imqcmd.user=" + adminUsername);
                v.add("-passfile");
                v.add(adminPassFile);
                this.adminPassFile = adminPassFile;
            } else if (adminPassword != null && !"".equals(adminPassword)) {
                v.add("-Dimq.imqcmd.user=" + adminUsername);
            }
        }
        if (brokerBindAddress != null && !"localhost".equals(brokerBindAddress)) {
            v.add("-Dimq.hostname=" + brokerBindAddress);
        }
        v.add("-save");
        this.brokerArgs = v.toArray(new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void start() throws Exception {
        boolean already_running;
        block18: {
            _loggerL.entering(_className, "start()");
            already_running = false;
            String running_varhome = null;
            if (this.startingRMIRegistry) {
                _loggerL.fine("MQJMSRA_LB1101: Looking for Broker Running at:" + this.brokerURL);
                try {
                    this.jmsadmin.pingProvider();
                    _loggerL.info("MQJMSRA_LB1101: Detected Broker Running at:" + this.brokerURL);
                    already_running = true;
                }
                catch (Exception e) {
                    already_running = false;
                }
                if (already_running) {
                    this.startedByAS = false;
                    try {
                        this.jmsadmin.connectToProvider();
                        running_varhome = this.jmsadmin.getProviderVarHome();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    _loggerL.info("MQJMSRA_LB1101: Detected Broker VAR directory=" + running_varhome);
                    if (running_varhome != null && !"".equals(running_varhome) && running_varhome.equals(this.brokerVarDir)) {
                        this.startedByAS = true;
                        break block18;
                    } else {
                        String excerrmsg = "MQJMSRA_LB4001: start:Broker running at:" + this.brokerURL + " has a different var directory of:" + running_varhome + ":Failing ra.start()";
                        _loggerL.severe(excerrmsg);
                        throw new Exception(excerrmsg);
                    }
                }
                this.jmsadmin.startProvider(this.brokerBinDir, this.brokerArgs, this.brokerInstanceName);
                this.startedByAS = true;
            } else {
                this.jmsadmin.startProvider(this.brokerBinDir, this.brokerArgs, this.brokerInstanceName);
                this.startedByAS = true;
            }
        }
        boolean ready = false;
        long firstPingTime = System.currentTimeMillis();
        while (true) {
            try {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!already_running) {
                    this.jmsadmin.connectToProvider();
                }
                ready = true;
            }
            catch (JMSSecurityException jmsse) {
                Exception startEx = new Exception("MQJMSRA_LB4001: start:Unable to ping Broker due to authentication error for user " + this.adminUsername + " : shutting down broker.");
                startEx.initCause(jmsse);
                try {
                    this.tjmsadmin.connectToProvider();
                    this.tjmsadmin.shutdownProvider();
                    throw startEx;
                }
                catch (Exception spe) {
                    _loggerL.warning("MQJMSRA_LB4001: start:Exception on LOCAL broker shutdown after connect auth failure:msg=" + spe.getMessage());
                }
                throw startEx;
            }
            catch (Exception e) {
                if (System.currentTimeMillis() - firstPingTime < (long)this.brokerStartTimeout) continue;
                _loggerL.severe("MQJMSRA_LB4001: start:Ping broker failed " + (System.currentTimeMillis() - firstPingTime) + " millis after broker start performed. Failing ra.start()");
                _loggerL.warning("MQJMSRA_LB4001: start:Aborting:Check Broker Log File at:" + this.brokerLogFilename);
            }
            break;
        }
        if (ready) return;
        throw new RuntimeException("MQJMSRA_LB4001: start:Aborted:Unable to ping Broker within " + this.brokerStartTimeout + " millis (startTimeOut)");
    }

    protected synchronized void stop() {
        block4: {
            _loggerL.entering(_className, "stop()");
            if (this.jmsadmin != null) {
                if (!this.startedByAS) {
                    _loggerL.warning("MQJMSRA_LB2001: stop:Skipping LOCAL broker shutdown:Broker not started by App Server");
                    return;
                }
                try {
                    this.jmsadmin.shutdownProvider();
                }
                catch (Exception bse) {
                    _loggerL.warning("MQJMSRA_LB4001: stop:Exception on LOCAL broker shutdown:msg=" + bse.getMessage());
                    if (!_loggerL.isLoggable(Level.FINER)) break block4;
                    bse.printStackTrace();
                }
            }
        }
    }

    private static void checkVersion(JMSAdmin jmsadm) {
        float ver_f = 0.0f;
        String ver_s = "?.?";
        try {
            ver_s = jmsadm.getVersion();
            ver_f = Float.parseFloat(ver_s);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing SJSMQ SPI version string (" + ver_s + ").");
        }
        if ((double)ver_f < 2.0 || (double)ver_f >= 3.0) {
            throw new RuntimeException("Incorrect SJSMQ SPI version detected (" + ver_s + ").");
        }
    }
}

