/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceFactory;
import com.sun.messaging.jmq.jmsserver.service.ServiceInfo;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceState;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ServiceManager {
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private static final String DEFAULT_HANDLER = "dedicated";
    Hashtable services = null;
    Hashtable servicehandlers = null;
    BrokerConfig config = Globals.getConfig();
    ConnectionManager conmgr = null;

    public ServiceManager(ConnectionManager conmgr) {
        this.services = new Hashtable();
        this.servicehandlers = new Hashtable();
        this.conmgr = conmgr;
    }

    protected ServiceFactory createServiceFactory(String handlername, boolean instOnly) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String key = "imq.service_handler." + handlername + ".class";
        String classname = this.config.getProperty(key);
        if (classname == null) {
            throw new ClassNotFoundException(Globals.getBrokerResources().getKString("B4451", key));
        }
        ServiceFactory hdlr = (ServiceFactory)Class.forName(classname).newInstance();
        hdlr.checkFactoryHandlerName(handlername);
        if (instOnly) {
            return hdlr;
        }
        hdlr.setFactoryHandlerName(handlername);
        hdlr.setConnectionManager(this.conmgr);
        return hdlr;
    }

    private int getServiceStateProp(String service) {
        String servicetypestr = this.config.getProperty("imq." + service + ".state");
        if (servicetypestr == null) {
            return -1;
        }
        return ServiceState.getStateFromString((String)servicetypestr);
    }

    private void removeServiceStateProp(String service) throws IOException {
        this.config.updateRemoveProperty("imq." + service + ".state", true);
    }

    private void setServiceStateProp(String service, int state) {
        try {
            if (state != 4) {
                this.removeServiceStateProp(service);
                return;
            }
            String statestr = ServiceState.getString((int)state);
            this.config.updateProperty("imq." + service + ".state", statestr);
        }
        catch (Exception ex) {
            this.logger.logStack(16, "B3100", (Object)("storing service state for " + service), (Throwable)ex);
        }
    }

    private String getHandlerName(String service) throws BrokerException {
        ServiceFactory.enforceServiceHandler(service, this.config, this);
        String handlerName = this.config.getProperty("imq." + service + ".handler_name");
        if (handlerName == null) {
            handlerName = this.config.getProperty("imq." + service + ".threadpool_model", DEFAULT_HANDLER);
        }
        return handlerName;
    }

    public Service createService(String service) throws ClassNotFoundException, InstantiationException, IllegalAccessException, BrokerException {
        String handlername = this.getHandlerName(service);
        ServiceFactory handler = (ServiceFactory)this.servicehandlers.get(handlername);
        if (handler == null) {
            handler = this.createServiceFactory(handlername, false);
            this.servicehandlers.put(handlername, handler);
        }
        String servicetypestr = this.config.getProperty("imq." + service + ".servicetype");
        int servicetype = ServiceType.getServiceType((String)servicetypestr);
        if (DEBUG) {
            this.logger.log(4, "Creating service {0} of type {1}", (Object)service, (Object)ServiceType.getString((int)servicetype));
        }
        Service s = handler.createService(service, servicetype);
        ServiceInfo si = new ServiceInfo(s, handler);
        this.services.put(service, si);
        return s;
    }

    public static List getAllServiceNames() {
        List activateList = Globals.getConfig().getList("imq.service.activate");
        List allSvcNames = Globals.getConfig().getList("imq.service.list");
        List additionalSvcNames = Globals.getConfig().getList("imq.service.runtimeAdd");
        if (additionalSvcNames != null) {
            if (allSvcNames != null) {
                allSvcNames.addAll(additionalSvcNames);
            } else {
                allSvcNames = additionalSvcNames;
            }
        }
        if (activateList != null) {
            for (String service : activateList) {
                if (allSvcNames.contains(service)) continue;
                allSvcNames.add(service);
            }
        }
        return allSvcNames;
    }

    public static List getAllActiveServiceNames() {
        List activateList = Globals.getConfig().getList("imq.service.activate");
        List allActiveSvcNames = Globals.getConfig().getList("imq.service.activelist");
        List additionalSvcNames = Globals.getConfig().getList("imq.service.runtimeAdd");
        if (additionalSvcNames != null) {
            if (allActiveSvcNames != null) {
                allActiveSvcNames.addAll(additionalSvcNames);
            } else {
                allActiveSvcNames = additionalSvcNames;
            }
        }
        if (activateList != null) {
            for (String service : activateList) {
                if (allActiveSvcNames.contains(service)) continue;
                allActiveSvcNames.add(service);
            }
        }
        return allActiveSvcNames;
    }

    public static String getServiceTypeString(String name) {
        return Globals.getConfig().getProperty("imq." + name + ".servicetype");
    }

    public Set getAllActiveServices() {
        return this.services.keySet();
    }

    public int getServiceState(String name) {
        ServiceInfo info = (ServiceInfo)this.services.get(name);
        if (info == null) {
            return -1;
        }
        return info.getState();
    }

    public int getServiceType(String name) {
        ServiceInfo info = (ServiceInfo)this.services.get(name);
        if (info == null) {
            return -1;
        }
        return info.getServiceType();
    }

    public Service getService(String name) {
        ServiceInfo info = (ServiceInfo)this.services.get(name);
        if (info == null) {
            return null;
        }
        return info.getService();
    }

    public void startService(String servicename, boolean pauseAtStartup) throws BrokerException {
        ServiceInfo info = (ServiceInfo)this.services.get(servicename);
        if (info != null) {
            info.start(pauseAtStartup);
            this.setServiceStateProp(servicename, 3);
        }
    }

    public void stopService(String servicename, boolean all) throws BrokerException {
        ServiceInfo info = (ServiceInfo)this.services.get(servicename);
        if (info != null) {
            info.stop(all);
        }
    }

    public void pauseService(String servicename, boolean pause_all) throws BrokerException {
        ServiceInfo info = (ServiceInfo)this.services.get(servicename);
        if (info != null) {
            info.pause(pause_all);
            this.setServiceStateProp(servicename, 4);
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.notifyServicePause(servicename);
            }
        }
    }

    public void stopNewConnections(String servicename) throws BrokerException {
        ServiceInfo info = (ServiceInfo)this.services.get(servicename);
        if (info != null) {
            info.stopNewConnections();
        }
    }

    public void startNewConnections(String servicename) throws BrokerException {
        ServiceInfo info = (ServiceInfo)this.services.get(servicename);
        if (info != null) {
            info.startNewConnections();
        }
    }

    public void startNewConnections(int service_type) throws BrokerException {
        Set activeServices = this.getAllActiveServices();
        for (String name : activeServices) {
            Service service = this.getService(name);
            if (this.getServiceType(name) != service_type || service.getState() == 3) continue;
            this.startNewConnections(name);
        }
    }

    public int getConnectionCount(int service_type) {
        int count = 0;
        Set activeServices = this.getAllActiveServices();
        for (String name : activeServices) {
            Service service = this.getService(name);
            if (this.getServiceType(name) != service_type) continue;
            count += this.conmgr.getNumConnections(service);
        }
        return count;
    }

    public void resumeService(String servicename) throws BrokerException {
        ServiceInfo info = (ServiceInfo)this.services.get(servicename);
        if (info != null) {
            info.resume();
            this.setServiceStateProp(servicename, 3);
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.notifyServiceResume(servicename);
            }
        }
    }

    public void stopAllActiveServices(boolean all) throws BrokerException {
        this.stopAllActiveServices(all, null);
    }

    public void stopAllActiveServices(boolean all, String excludedServiceName) throws BrokerException {
        Set activeServices = this.getAllActiveServices();
        for (String name : activeServices) {
            if (excludedServiceName != null && name.equals(excludedServiceName)) continue;
            this.stopService(name, all);
        }
    }

    public void stopNewConnections(int service_type) throws BrokerException {
        Set activeServices = this.getAllActiveServices();
        for (String name : activeServices) {
            Service service = this.getService(name);
            if (this.getServiceType(name) != service_type || service.getState() != 3) continue;
            this.stopNewConnections(name);
        }
    }

    public void pauseAllActiveServices(int service_type, boolean pause_all) throws BrokerException {
        Set activeServices = this.getAllActiveServices();
        for (String name : activeServices) {
            Service service = this.getService(name);
            if (this.getServiceType(name) != service_type || service.getState() != 3) continue;
            this.pauseService(name, pause_all);
        }
    }

    public void resumeAllActiveServices(int service_type) throws BrokerException {
        this.resumeAllActiveServices(service_type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAllActiveServices(int service_type, boolean startup) throws BrokerException {
        try {
            Set activeServices = this.getAllActiveServices();
            for (String name : activeServices) {
                Service service = this.getService(name);
                if (this.getServiceType(name) != service_type || service.getState() != 4) continue;
                this.resumeService(name);
            }
        }
        finally {
            if (startup) {
                Globals.getDestinationList();
                DestinationList.translistPostProcess(null);
            }
        }
    }

    public void updateServiceList(List updatedsvcs) {
        this.updateServiceList(updatedsvcs, -1);
    }

    public void updateServiceList(List updatedsvcs, int service_type) {
        this.updateServiceList(updatedsvcs, service_type, false);
    }

    public void updateServiceList(List updatedsvcs, int service_type, boolean pauseIfStarting) {
        this.updateServiceList(updatedsvcs, service_type, pauseIfStarting, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceList(List updatedsvcs, int service_type, boolean pauseIfStarting, boolean startup) {
        try {
            Set running = this.getAllActiveServices();
            for (String service : running) {
                if (service_type != -1 && this.getServiceType(service) != service_type || updatedsvcs.contains(service)) continue;
                if (DEBUG) {
                    this.logger.log(4, "Destroying service {0}", (Object)service);
                }
                ServiceInfo info = (ServiceInfo)this.services.get(service);
                try {
                    info.stop(true);
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "B2017", (Object)service, (Throwable)ex);
                }
                try {
                    info.destroy();
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "B2018", (Object)service, (Throwable)ex);
                }
                this.setServiceStateProp(service, -1);
                this.services.remove(service);
            }
            for (int i = 0; i < updatedsvcs.size(); ++i) {
                String service = (String)updatedsvcs.get(i);
                if (DEBUG) {
                    this.logger.log(4, "Checking service {0}", (Object)service);
                }
                ServiceInfo info = (ServiceInfo)this.services.get(service);
                try {
                    int curstate;
                    int state = this.getServiceStateProp(service);
                    if (info == null || info.getState() == 7) {
                        if (DEBUG) {
                            this.logger.log(4, "Creating service {0}", (Object)service);
                        }
                        this.createService(service);
                    }
                    if (service_type != -1 && this.getServiceType(service) != service_type) continue;
                    int n = curstate = info == null ? -1 : info.getState();
                    if (curstate < 3 || curstate > 4) {
                        this.startService(service, pauseIfStarting);
                    }
                    if (state != 4 || curstate == 4) continue;
                    this.logger.log(8, "B1124", (Object)service);
                    this.pauseService(service, true);
                    continue;
                }
                catch (BrokerException ex) {
                    String str = ex.getMessage();
                    if (ex.getCause() != null) {
                        str = str + ": " + ex.getCause().getMessage();
                    }
                    this.logger.logStack(32, "B3009", (Object)(service + ": " + str), (Throwable)ex);
                    this.logger.log(4, "", (Throwable)ex);
                    continue;
                }
                catch (OutOfMemoryError err) {
                    throw err;
                }
                catch (Throwable ex) {
                    String str = ex.getMessage();
                    if (ex.getCause() != null) {
                        str = str + ": " + ex.getCause().getMessage();
                    }
                    this.logger.log(32, "B3009", (Object)service, ex);
                }
            }
        }
        finally {
            if (startup) {
                Globals.getDestinationList();
                DestinationList.translistPostProcess(null);
            }
        }
    }

    public void addServiceRestriction(int service_type, ServiceRestriction svcres) {
        Set activeServices = this.getAllActiveServices();
        Iterator itr = activeServices.iterator();
        Service service = null;
        while (itr.hasNext()) {
            String name = (String)itr.next();
            if (this.getServiceType(name) != service_type || (service = this.getService(name)) == null) continue;
            service.addServiceRestriction(svcres);
        }
    }

    public void removeServiceRestriction(int service_type, ServiceRestriction svcres) {
        Set activeServices = this.getAllActiveServices();
        Iterator itr = activeServices.iterator();
        Service service = null;
        while (itr.hasNext()) {
            String name = (String)itr.next();
            if (this.getServiceType(name) != service_type || (service = this.getService(name)) == null) continue;
            service.removeServiceRestriction(svcres);
        }
    }
}

