/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.disk.ObjectInputStreamCallback;
import com.sun.messaging.jmq.io.disk.PHashMap;
import com.sun.messaging.jmq.io.disk.PHashMapLoadException;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;

class InterestStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    BrokerConfig config = Globals.getConfig();
    static final String INTEREST_FILE_SIZE_PROP = "imq.persist.file.interest.file.size";
    static final long DEFAULT_INTEREST_FILE_SIZE = 1024L;
    static final String BASENAME = "interest";
    private File backingFile = null;
    private PHashMap interestMap = null;
    private LoadException loadException = null;

    InterestStore(FileStore p, File topDir, boolean clear) throws BrokerException {
        SizeString filesize = this.config.getSizeProperty(INTEREST_FILE_SIZE_PROP, 1024L);
        this.backingFile = new File(topDir, BASENAME);
        try {
            this.interestMap = new PHashMap(this.backingFile, filesize.getBytes(), false, clear, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            throw new BrokerException(this.br.getString("B4035"), e);
        }
        try {
            this.interestMap.load((ObjectInputStreamCallback)p);
        }
        catch (IOException e) {
            throw new BrokerException(this.br.getString("B4035"), e);
        }
        catch (ClassNotFoundException e) {
            throw new BrokerException(this.br.getString("B4035"), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4195", (Throwable)le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = this.interestMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of consumer data", (Throwable)w);
        }
        if (clear && Store.getDEBUG()) {
            this.logger.log(1, "InterestStore initialized with clear option");
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "LOADED " + this.interestMap.size() + " INTERESTS");
        }
    }

    InterestStore(FileStore p, File topDir, File oldDir, boolean clear) throws BrokerException {
        SizeString filesize = this.config.getSizeProperty(INTEREST_FILE_SIZE_PROP, 1024L);
        File oldFile = new File(oldDir, BASENAME);
        PHashMap olddata = null;
        this.backingFile = new File(topDir, BASENAME);
        try {
            olddata = new PHashMap(oldFile, false, clear, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4155", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4155", oldFile, this.backingFile), e);
        }
        try {
            olddata.load((ObjectInputStreamCallback)p);
        }
        catch (IOException e) {
            this.logger.log(32, "B4155", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4155", oldFile, this.backingFile), e);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(32, "B4155", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4155", oldFile, this.backingFile), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4200", (Throwable)le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = olddata.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of consumer data in old store", (Throwable)w);
        }
        try {
            this.interestMap = new PHashMap(this.backingFile, oldFile.length(), false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4155", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4155", oldFile, this.backingFile), e);
        }
        try {
            this.interestMap.load((ObjectInputStreamCallback)p);
        }
        catch (IOException e) {
            this.logger.log(32, "B4155", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4155", oldFile, this.backingFile), e);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(32, "B4155", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4155", oldFile, this.backingFile), e);
        }
        catch (PHashMapLoadException e) {
            this.logger.log(32, "B4155", (Object)oldFile, (Object)this.backingFile, (Throwable)e);
            throw new BrokerException(this.br.getString("B4155", oldFile, this.backingFile), e);
        }
        w = this.interestMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of consumer data", (Throwable)w);
        }
        for (Map.Entry entry : olddata.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.interestMap.put(key, value);
        }
        olddata.close();
        if (Store.getDEBUG()) {
            this.logger.log(4, "UPGRADED " + this.interestMap.size() + " INTERESTS");
        }
        if (p.upgradeNoBackup() && !oldFile.delete()) {
            this.logger.log(32, "B1044", (Object)oldFile);
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    private void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String msg = "InterestStore sync()";
                this.logger.log(4, msg);
            }
            this.interestMap.force();
        }
        catch (IOException e) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, e);
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Consumers", String.valueOf(this.interestMap.size()));
        return t;
    }

    public void printInfo(PrintStream out) {
        out.println("\nInterests");
        out.println("---------");
        out.println("backing file: " + this.backingFile);
        out.println("number of interests:   " + this.interestMap.size());
    }

    void storeInterest(Consumer interest, boolean sync) throws IOException, BrokerException {
        ConsumerUID id = interest.getConsumerUID();
        try {
            Object oldValue = this.interestMap.putIfAbsent((Object)id, (Object)interest);
            if (oldValue != null) {
                this.logger.log(32, "B3010", (Object)id, (Object)interest.getDestinationUID().getLongString());
                throw new BrokerException(this.br.getString("B3010", id, interest.getDestinationUID().getLongString()));
            }
            if (sync) {
                this.sync();
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4012", (Object)id, (Throwable)e);
            throw e;
        }
    }

    void removeInterest(Consumer interest, boolean sync) throws IOException, BrokerException {
        Object oldinterest = null;
        ConsumerUID id = interest.getConsumerUID();
        try {
            oldinterest = this.interestMap.remove((Object)id);
            if (oldinterest == null) {
                this.logger.log(32, "B3011", (Object)id, (Object)interest.getDestinationUID().getLongString());
                throw new BrokerException(this.br.getString("B3011", id, interest.getDestinationUID().getLongString()));
            }
            if (sync) {
                this.sync();
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4034", (Object)id);
            throw new BrokerException(this.br.getString("B4034", id), e);
        }
    }

    Consumer[] getAllInterests() throws IOException {
        return this.interestMap.values().toArray(new Consumer[0]);
    }

    void clearAll(boolean sync) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "InterestStore.clearAll() called");
        }
        this.interestMap.clear();
        if (sync) {
            try {
                this.sync();
            }
            catch (BrokerException e) {
                this.logger.log(32, "Got exception while synchronizing data to disk", (Throwable)e);
            }
        }
    }

    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "InterestStore: closing, " + this.interestMap.size() + " persisted interests");
        }
        this.interestMap.close();
    }
}

