/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.scripts;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.AbstractPrePostTagHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ListTagHandler
extends AbstractPrePostTagHandler {
    @Override
    public String doRun(ITag tag) throws GenDocException {
        String value = super.doRun(tag);
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        StringBuffer returnValue = new StringBuffer(value);
        String listLabel = documentService.getListLabel();
        if (listLabel != null) {
            Pattern listPattern = Pattern.compile("<" + listLabel + "[^<>]*>.*" + "</" + listLabel + ">");
            Matcher m = listPattern.matcher(returnValue);
            if (!m.find()) {
                return returnValue.toString();
            }
            int indexStart = m.start();
            int indexEnd = returnValue.lastIndexOf("</" + listLabel + ">");
            String listText = returnValue.substring(indexStart, indexEnd += listLabel.length() + 3);
            String singleList = this.addContinueListTagAttribute(documentService, listText);
            returnValue.replace(indexStart, indexEnd, singleList);
        }
        return returnValue.toString();
    }

    private String addContinueListTagAttribute(IDocumentService documentService, String listText) throws InvalidContentException {
        StringBuffer finalListText = new StringBuffer();
        String nodes = "<document>" + listText + "</document>";
        nodes = documentService.addNamingSpaces(nodes, "document");
        nodes = documentService.cleanTextTag(nodes).toString();
        Node listNode = documentService.asNode(nodes).getFirstChild();
        Node firstList = listNode.getFirstChild();
        finalListText.append(documentService.asText(firstList));
        String idList = documentService.getListId(firstList);
        NodeList childNodes = listNode.getChildNodes();
        int i = 1;
        while (i < childNodes.getLength()) {
            Node currentNode = childNodes.item(i);
            if (documentService.isList(currentNode.getNodeName())) {
                finalListText.append(documentService.getContinueList(currentNode, idList));
            } else {
                finalListText.append(documentService.asText(currentNode));
            }
            ++i;
        }
        return finalListText.toString();
    }
}

