/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.IPostTagHandler;
import org.eclipse.gendoc.tags.IPreTagHandler;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.AbstractTagHandler;

public abstract class AbstractPrePostTagHandler
extends AbstractTagHandler {
    private static Map<String, SortedSet<PriorityPreHandler>> preHandlers = new HashMap<String, SortedSet<PriorityPreHandler>>();
    private static Map<String, SortedSet<PriorityPostHandler>> postHandlers = new HashMap<String, SortedSet<PriorityPostHandler>>();

    static {
        AbstractPrePostTagHandler.initHandlers();
    }

    public final String run(ITag tag) throws GenDocException {
        ITag newTag = this.preRun(tag);
        String value = this.doRun(newTag);
        value = this.postRun(newTag, value);
        return value;
    }

    private static void initHandlers() {
        IConfigurationElement[] extensions;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = extensionRegistry.getConfigurationElementsFor("org.eclipse.gendoc.tags.handlers", "sequencer");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            TreeSet<IPriority> list;
            IConfigurationElement e = iConfigurationElementArray[n2];
            String tagName = e.getAttribute("tag_name");
            int priority = Integer.parseInt(e.getAttribute("priority"));
            Object handler = null;
            if ("pre_tag_handler".equals(e.getName())) {
                try {
                    list = (TreeSet<IPriority>)preHandlers.get(tagName);
                    if (list == null) {
                        list = new TreeSet<IPriority>(new PriorityComparator());
                        preHandlers.put(tagName, (SortedSet<PriorityPreHandler>)list);
                    }
                    handler = e.createExecutableExtension("runnable");
                    list.add(new PriorityPreHandler((IPreTagHandler)handler, priority));
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            } else if ("post_tag_handler".equals(e.getName())) {
                try {
                    list = postHandlers.get(tagName);
                    if (list == null) {
                        list = new TreeSet<IPriority>(new PriorityComparator());
                        postHandlers.put(tagName, (SortedSet<PriorityPostHandler>)list);
                    }
                    handler = e.createExecutableExtension("runnable");
                    list.add(new PriorityPostHandler((IPostTagHandler)handler, priority));
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
            ++n2;
        }
    }

    protected String doRun(ITag tag) throws GenDocException {
        return super.run(tag);
    }

    protected ITag preRun(ITag tag) throws GenDocException {
        SortedSet<PriorityPreHandler> extensionPre = preHandlers.get(tag.getName());
        if (extensionPre != null) {
            for (PriorityPreHandler preRunnable : extensionPre) {
                tag = preRunnable.preRun(tag);
            }
        }
        return tag;
    }

    protected String postRun(ITag tag, String str) throws GenDocException {
        SortedSet<PriorityPostHandler> extensionPost = postHandlers.get(tag.getName());
        if (extensionPost != null) {
            for (PriorityPostHandler postRunnable : extensionPost) {
                str = postRunnable.postRun(tag, str);
            }
        }
        return str;
    }

    private static interface IPriority {
        public int getPriority();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PriorityComparator
    implements Comparator<IPriority> {
        @Override
        public int compare(IPriority arg0, IPriority arg1) {
            Integer a = -1;
            Integer b = -1;
            if (arg0 != null) {
                a = arg0.getPriority();
            }
            if (arg1 != null) {
                b = arg1.getPriority();
            }
            if (a == b) {
                return new Integer(arg0.hashCode()).compareTo(new Integer(arg1.hashCode()));
            }
            return a.compareTo(b);
        }
    }

    private static class PriorityPostHandler
    implements IPostTagHandler,
    IPriority {
        private final IPostTagHandler handler;
        private final int priority;

        public PriorityPostHandler(IPostTagHandler handler, int priority) {
            this.handler = handler;
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public String postRun(ITag tag, String value) throws GenDocException {
            return this.handler.postRun(tag, value);
        }
    }

    private static class PriorityPreHandler
    implements IPreTagHandler,
    IPriority {
        private final IPreTagHandler handler;
        private final int priority;

        public PriorityPreHandler(IPreTagHandler handler, int priority) {
            this.handler = handler;
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public ITag preRun(ITag tag) throws GenDocException {
            return this.handler.preRun(tag);
        }
    }
}

